/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class Bert
implements ActionListener {
    public JFrame frame;
    private JPanel frameContainer;
    private JButton cancelbtn;
    private JButton downloadbtn;
    private JRadioButton baseCheck;
    private JRadioButton patchCheck1;
    private JRadioButton patchCheck2;
    private JCheckBox hdCheck;
    private JCheckBox furyCheck;
    private JCheckBox skipBaseCheck;
    private JPanel installedList;
    private JLabel ipcBase;
    private JLabel ipcPatch1;
    private JLabel ipcPatch2;
    private JLabel ipcDlcHD;
    private JLabel ipcDlcFury;
    private JPanel installedListMargin;
    private ButtonGroup radios;
    private JFrame invoker;
    private boolean wilkinsDownloadFinished;

    public Bert(final JFrame parent) {
        this.$$$setupUI$$$();
        this.frame = new JFrame();
        this.radios = new ButtonGroup();
        this.wilkinsDownloadFinished = false;
        parent.setEnabled(false);
        this.invoker = parent;
        this.frame.add(this.frameContainer);
        this.frame.setSize(600, 300);
        this.frame.setTitle("Download Assets");
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setLayout(new GridLayout());
        this.frame.setLocationRelativeTo(parent);
        this.frame.setAlwaysOnTop(true);
        this.radios.add(this.baseCheck);
        this.radios.add(this.patchCheck1);
        this.radios.add(this.patchCheck2);
        this.cancelbtn.addActionListener(this);
        this.downloadbtn.addActionListener(this);
        this.baseCheck.addActionListener(this);
        this.patchCheck1.addActionListener(this);
        this.patchCheck2.addActionListener(this);
        this.refreshChecklist();
        this.frame.setIconImage(Main.windowIcon);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                parent.setEnabled(true);
                e.getWindow().dispose();
            }
        });
        if (!new File(Main.inpath + "pkg2zip.exe").exists() || !new File(Main.inpath + "psvpfsparser.exe").exists()) {
            JOptionPane.showMessageDialog(this.frame, "The decryption tool is missing.\nPlease select \"Get Dependencies\" in the Options menu.", "Error", 0);
            this.invoker.setEnabled(true);
            this.frame.dispose();
        }
        if (new File(Main.inpath + "data2.psarc").exists()) {
            this.skipBaseCheck.setEnabled(true);
        }
    }

    public boolean reportWhenDownloaded(WilkinsCoffee setup) {
        while (this.frame.isActive() || !this.wilkinsDownloadFinished) {
        }
        return this.wilkinsDownloadFinished;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.baseCheck) {
            this.skipBaseCheck.setEnabled(new File(Main.inpath + "data.psarc").exists());
        } else if (actionEvent.getSource() == this.patchCheck1) {
            this.skipBaseCheck.setEnabled(new File(Main.inpath + "data1.psarc").exists());
        } else if (actionEvent.getSource() == this.patchCheck2) {
            this.skipBaseCheck.setEnabled(new File(Main.inpath + "data2.psarc").exists());
        } else if (actionEvent.getSource() == this.cancelbtn) {
            this.invoker.setEnabled(true);
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.downloadbtn) {
            final ArrayList<Main.ArcTarget> arcs = new ArrayList<Main.ArcTarget>();
            ArrayList<Main.ArcKey> keys = new ArrayList<Main.ArcKey>();
            if (!(!this.baseCheck.isSelected() || this.skipBaseCheck.isSelected() && new File(Main.inpath + "data.psarc").exists())) {
                arcs.add(Main.ArcTarget.BASE);
                keys.add(Main.ArcKey.BASE);
                System.out.println("Queued download of data (Game version 1.0)");
            }
            if (this.patchCheck1.isSelected()) {
                if (!new File(Main.inpath + "data.psarc").exists()) {
                    arcs.add(Main.ArcTarget.BASE);
                    keys.add(Main.ArcKey.BASE);
                    System.out.println("Queued download of data (Game version 1.0)");
                }
                if (!this.skipBaseCheck.isSelected() || !new File(Main.inpath + "data1.psarc").exists()) {
                    arcs.add(Main.ArcTarget.FIRST);
                    keys.add(Main.ArcKey.FIRST);
                    System.out.println("Queued download of data1 (Game version 1.01)");
                }
            }
            if (this.patchCheck2.isSelected()) {
                if (!new File(Main.inpath + "data.psarc").exists()) {
                    arcs.add(Main.ArcTarget.BASE);
                    keys.add(Main.ArcKey.BASE);
                    System.out.println("Queued download of data (Game version 1.0)");
                }
                if (!new File(Main.inpath + "data1.psarc").exists()) {
                    arcs.add(Main.ArcTarget.FIRST);
                    keys.add(Main.ArcKey.FIRST);
                    System.out.println("Queued download of data1 (Game version 1.01)");
                }
                if (!this.skipBaseCheck.isSelected() || !new File(Main.inpath + "data2.psarc").exists()) {
                    arcs.add(Main.ArcTarget.LATEST);
                    keys.add(Main.ArcKey.LATEST);
                    System.out.println("Queued download of data2 (Game version 1.04)");
                }
            }
            if (this.hdCheck.isSelected()) {
                arcs.add(Main.ArcTarget.ADDON_HD);
                keys.add(Main.ArcKey.ADDON_HD);
                System.out.println("Queued download of dlc1 (HD DLC)");
            }
            if (this.furyCheck.isSelected()) {
                arcs.add(Main.ArcTarget.ADDON_HD_FURY);
                keys.add(Main.ArcKey.ADDON_HD_FURY);
                System.out.println("Queued download of dlc2 (Fury DLC)");
            }
            if (arcs.isEmpty()) {
                this.frame.setVisible(false);
                JOptionPane.showMessageDialog(this.invoker, "Select one or more asset packs.", "Error", 0);
                this.frame.setVisible(true);
                return;
            }
            this.frame.dispose();
            this.invoker.setVisible(false);
            Thread downloaderPopupThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Main.ArcTarget type : arcs) {
                        String name;
                        String extracted;
                        String key = "";
                        String arcname = "";
                        switch (type) {
                            case BASE: {
                                key = Main.ArcKey.BASE.toString();
                                arcname = "Base game";
                                break;
                            }
                            case FIRST: {
                                key = Main.ArcKey.FIRST.toString();
                                arcname = "Update 1.01";
                                break;
                            }
                            case LATEST: {
                                key = Main.ArcKey.LATEST.toString();
                                arcname = "Update 1.04";
                                break;
                            }
                            case ADDON_HD: {
                                key = Main.ArcKey.ADDON_HD.toString();
                                arcname = "HD Add-On Pack";
                                break;
                            }
                            case ADDON_HD_FURY: {
                                key = Main.ArcKey.ADDON_HD_FURY.toString();
                                arcname = "Fury Add-On Pack";
                            }
                        }
                        if (key.isEmpty()) {
                            System.out.println("Internal Error: Bert got dementia. Get a programmer!");
                            JOptionPane.showMessageDialog(Bert.this.invoker, "Internal Error: Bert got dementia. Get a programmer!", "Fatal Error", 0);
                            return;
                        }
                        Fozzie downloaderHandler = new Fozzie();
                        boolean downloader = downloaderHandler.DownloadFile(type.toString(), Main.inpath, "asset.pkg", arcname);
                        if (!downloader) {
                            new File(Main.inpath + "asset.pkg").delete();
                            Bert.this.invoker.setEnabled(true);
                            Bert.this.invoker.setVisible(true);
                            Bert.this.invoker.toFront();
                            Bert.this.invoker.repaint();
                            return;
                        }
                        System.out.println("Extracting " + arcname);
                        Fozzie popup = new Fozzie();
                        popup.displayTextOnly("Extracting " + arcname + "...", "Extracting");
                        try {
                            int c;
                            Process p = Main.exec(new String[]{Main.inpath + "pkg2zip.exe", "-x", "asset.pkg", key.toString()}, Main.inpath);
                            BufferedInputStream debugin = new BufferedInputStream(p.getInputStream());
                            BufferedOutputStream debugout = new BufferedOutputStream(System.out);
                            while ((c = ((InputStream)debugin).read()) != -1) {
                                ((OutputStream)debugout).write(c);
                            }
                            ((InputStream)debugin).close();
                            ((OutputStream)debugout).close();
                            p.waitFor();
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            JOptionPane.showMessageDialog(Bert.this.invoker, "CRITICAL FAILURE: " + e.getMessage(), "Fatal Error", 0);
                            new File(Main.inpath + "asset.pkg").delete();
                            Bert.this.invoker.setEnabled(true);
                            Bert.this.invoker.setVisible(true);
                            Bert.this.invoker.toFront();
                            Bert.this.invoker.repaint();
                            return;
                        }
                        System.out.println("Decrypting asset.pkg");
                        if (type == Main.ArcTarget.BASE) {
                            extracted = "app/PCSA00015";
                            name = "data.psarc";
                        } else if (type == Main.ArcTarget.FIRST) {
                            extracted = "patch/PCSA00015";
                            name = "data1.psarc";
                        } else if (type == Main.ArcTarget.LATEST) {
                            extracted = "patch/PCSA00015";
                            name = "data2.psarc";
                        } else if (type == Main.ArcTarget.ADDON_HD) {
                            extracted = "addcont/PCSA00015/DLC1W2048PACKAGE";
                            name = "dlc1.psarc";
                        } else if (type == Main.ArcTarget.ADDON_HD_FURY) {
                            extracted = "addcont/PCSA00015/DLC2W2048PACKAGE";
                            name = "dlc2.psarc";
                        } else {
                            System.out.println("Internal Error: Bert got dementia. Get a programmer!");
                            JOptionPane.showMessageDialog(Bert.this.invoker, "Internal Error: Bert got dementia. Get a programmer!", "Fatal Error", 0);
                            new File(Main.inpath + "asset.pkg").delete();
                            Main.deleteDir(new File(Main.inpath + "app/"));
                            Main.deleteDir(new File(Main.inpath + "patch/"));
                            Main.deleteDir(new File(Main.inpath + "addcont/"));
                            Bert.this.invoker.setEnabled(true);
                            Bert.this.invoker.setVisible(true);
                            Bert.this.invoker.toFront();
                            Bert.this.invoker.repaint();
                            return;
                        }
                        popup.setText("<html>Decrypting protected PFS:<br/>" + extracted + "</html>", "Decrypting");
                        try {
                            int c;
                            Process p = Main.exec(new String[]{Main.inpath + "psvpfsparser.exe", "-i", extracted, "-o", "./temp/", "-z", key.toString(), "-f", "cma.henkaku.xyz"}, Main.inpath);
                            BufferedInputStream debugin = new BufferedInputStream(p.getInputStream());
                            BufferedOutputStream debugout = new BufferedOutputStream(System.out);
                            while ((c = ((InputStream)debugin).read()) != -1) {
                                ((OutputStream)debugout).write(c);
                            }
                            ((InputStream)debugin).close();
                            ((OutputStream)debugout).close();
                            p.waitFor();
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            JOptionPane.showMessageDialog(Bert.this.invoker, "CRITICAL FAILURE: " + e.getMessage(), "Fatal Error", 0);
                            new File(Main.inpath + "asset.pkg").delete();
                            Main.deleteDir(new File(Main.inpath + "app/"));
                            Main.deleteDir(new File(Main.inpath + "patch/"));
                            Main.deleteDir(new File(Main.inpath + "addcont/"));
                            Bert.this.invoker.setEnabled(true);
                            Bert.this.invoker.setVisible(true);
                            Bert.this.invoker.toFront();
                            Bert.this.invoker.repaint();
                            return;
                        }
                        popup.setText("Deleting temporary files...", "Cleaning Up");
                        System.out.println("Cleaning up");
                        new File(Main.inpath + "asset.pkg").delete();
                        new File(Main.inpath + "temp/PSP2/" + name).renameTo(new File(Main.inpath + name));
                        Main.deleteDir(new File(Main.inpath + "app/"));
                        Main.deleteDir(new File(Main.inpath + "patch/"));
                        Main.deleteDir(new File(Main.inpath + "addcont/"));
                        Main.deleteDir(new File(Main.inpath + "temp/"));
                        popup.destroyDialog();
                    }
                    JOptionPane.showMessageDialog(Bert.this.frame, "Assets downloaded successfully.", "Download Complete", 1);
                    Bert.this.invoker.setEnabled(true);
                    Bert.this.invoker.setVisible(true);
                    Bert.this.invoker.toFront();
                    Bert.this.invoker.repaint();
                    Bert.this.wilkinsDownloadFinished = true;
                }
            });
            downloaderPopupThread.start();
        }
    }

    private void refreshChecklist() {
        ImageIcon positive = new ImageIcon(Main.class.getResource("/lightPositive.png"));
        ImageIcon negative = new ImageIcon(Main.class.getResource("/lightNegative.png"));
        if (new File(Main.inpath + "data.psarc").exists()) {
            this.ipcBase.setIcon(positive);
        } else {
            this.ipcBase.setIcon(negative);
        }
        if (new File(Main.inpath + "data1.psarc").exists()) {
            this.ipcPatch1.setIcon(positive);
        } else {
            this.ipcPatch1.setIcon(negative);
        }
        if (new File(Main.inpath + "data2.psarc").exists()) {
            this.ipcPatch2.setIcon(positive);
        } else {
            this.ipcPatch2.setIcon(negative);
        }
        if (new File(Main.inpath + "dlc1.psarc").exists()) {
            this.ipcDlcHD.setIcon(positive);
        } else {
            this.ipcDlcHD.setIcon(negative);
        }
        if (new File(Main.inpath + "dlc2.psarc").exists()) {
            this.ipcDlcFury.setIcon(positive);
        } else {
            this.ipcDlcFury.setIcon(negative);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel3;
        this.frameContainer = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 1, new Insets(10, 25, 10, 25), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-15128227));
        Font font = this.$$$getFont$$$("Exo 2", -1, -1, jPanel3.getFont());
        if (font != null) {
            jPanel3.setFont(font);
        }
        ((Component)jPanel3).setForeground(new Color(-1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setBackground(new Color(-15128227));
        Font font2 = this.$$$getFont$$$("Exo 2", -1, -1, jPanel4.getFont());
        if (font2 != null) {
            jPanel4.setFont(font2);
        }
        ((Component)jPanel4).setForeground(new Color(-1));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setBackground(new Color(-15128227));
        Font font3 = this.$$$getFont$$$("Exo 2", -1, -1, jPanel5.getFont());
        if (font3 != null) {
            jPanel5.setFont(font3);
        }
        ((Component)jPanel5).setForeground(new Color(-1));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        Font font4 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel6.getFont());
        if (font4 != null) {
            jLabel6.setFont(font4);
        }
        ((Component)jLabel6).setForeground(new Color(-1));
        jLabel6.setText("Select the required asset packs below.");
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        Font font5 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel7.getFont());
        if (font5 != null) {
            jLabel7.setFont(font5);
        }
        ((Component)jLabel7).setForeground(new Color(-1));
        jLabel7.setText("This will depend on what version of the game you have and what DLC you own.");
        jPanel5.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        Font font6 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel8.getFont());
        if (font6 != null) {
            jLabel8.setFont(font6);
        }
        ((Component)jLabel8).setForeground(new Color(-1));
        jLabel8.setText("Downloading a game update will automatically download its previous versions.");
        jPanel5.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setBackground(new Color(-15128227));
        Font font7 = this.$$$getFont$$$("Exo 2", -1, -1, jPanel6.getFont());
        if (font7 != null) {
            jPanel6.setFont(font7);
        }
        ((Component)jPanel6).setForeground(new Color(-1));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.cancelbtn = jButton2 = new JButton();
        ((Component)jButton2).setBackground(new Color(-2271221));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        Font font8 = this.$$$getFont$$$("Exo 2", -1, -1, jButton2.getFont());
        if (font8 != null) {
            jButton2.setFont(font8);
        }
        ((Component)jButton2).setForeground(new Color(-1));
        jButton2.setText("Cancel");
        jPanel6.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        this.downloadbtn = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-2271221));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        Font font9 = this.$$$getFont$$$("Exo 2", -1, -1, jButton.getFont());
        if (font9 != null) {
            jButton.setFont(font9);
        }
        ((Component)jButton).setForeground(new Color(-1));
        jButton.setText("Download");
        jPanel6.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 2, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel7).setBackground(new Color(-15128227));
        Font font10 = this.$$$getFont$$$("Exo 2", -1, -1, jPanel7.getFont());
        if (font10 != null) {
            jPanel7.setFont(font10);
        }
        ((Component)jPanel7).setForeground(new Color(-1));
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.hdCheck = jCheckBox3 = new JCheckBox();
        ((Component)jCheckBox3).setBackground(new Color(-15128227));
        jCheckBox3.setFocusPainted(false);
        Font font11 = this.$$$getFont$$$("Exo 2", -1, -1, jCheckBox3.getFont());
        if (font11 != null) {
            jCheckBox3.setFont(font11);
        }
        ((Component)jCheckBox3).setForeground(new Color(-1));
        jCheckBox3.setHorizontalTextPosition(10);
        jCheckBox3.setOpaque(false);
        jCheckBox3.setText("HD Add-On Pack");
        jCheckBox3.setVerticalTextPosition(0);
        jPanel7.add((Component)jCheckBox3, new GridConstraints(2, 1, 1, 1, 5, 0, 3, 0, null, null, null));
        this.furyCheck = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setBackground(new Color(-15128227));
        jCheckBox2.setFocusPainted(false);
        Font font12 = this.$$$getFont$$$("Exo 2", -1, -1, jCheckBox2.getFont());
        if (font12 != null) {
            jCheckBox2.setFont(font12);
        }
        ((Component)jCheckBox2).setForeground(new Color(-1));
        jCheckBox2.setHorizontalTextPosition(11);
        jCheckBox2.setOpaque(false);
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Fury Add-On Pack");
        jCheckBox2.setVerticalTextPosition(0);
        jPanel7.add((Component)jCheckBox2, new GridConstraints(2, 2, 1, 1, 9, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setBackground(new Color(-15128227));
        jPanel8.setOpaque(false);
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 1, 1, 2, 2, 0, 1, 0, null, null, null));
        this.baseCheck = jRadioButton3 = new JRadioButton();
        ((Component)jRadioButton3).setBackground(new Color(-15128227));
        jRadioButton3.setFocusPainted(false);
        Font font13 = this.$$$getFont$$$("Exo 2", -1, -1, jRadioButton3.getFont());
        if (font13 != null) {
            jRadioButton3.setFont(font13);
        }
        ((Component)jRadioButton3).setForeground(new Color(-1));
        jRadioButton3.setHorizontalAlignment(0);
        jRadioButton3.setHorizontalTextPosition(11);
        jRadioButton3.setOpaque(false);
        jRadioButton3.setText("Base Game");
        jPanel8.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 0, null, null, null));
        this.patchCheck2 = jRadioButton2 = new JRadioButton();
        ((Component)jRadioButton2).setBackground(new Color(-15128227));
        jRadioButton2.setFocusPainted(false);
        Font font14 = this.$$$getFont$$$("Exo 2", -1, -1, jRadioButton2.getFont());
        if (font14 != null) {
            jRadioButton2.setFont(font14);
        }
        ((Component)jRadioButton2).setForeground(new Color(-1));
        jRadioButton2.setLabel("v1.04 (Latest)");
        jRadioButton2.setOpaque(false);
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("v1.04 (Latest)");
        jPanel8.add((Component)jRadioButton2, new GridConstraints(1, 2, 1, 1, 2, 0, 3, 0, null, null, null));
        this.patchCheck1 = jRadioButton = new JRadioButton();
        ((Component)jRadioButton).setBackground(new Color(-15128227));
        jRadioButton.setFocusPainted(false);
        Font font15 = this.$$$getFont$$$("Exo 2", -1, -1, jRadioButton.getFont());
        if (font15 != null) {
            jRadioButton.setFont(font15);
        }
        ((Component)jRadioButton).setForeground(new Color(-1));
        jRadioButton.setOpaque(false);
        jRadioButton.setText("v1.01+");
        jPanel8.add((Component)jRadioButton, new GridConstraints(1, 1, 1, 1, 2, 0, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        ((Component)jLabel9).setBackground(new Color(-15128227));
        Font font16 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel9.getFont());
        if (font16 != null) {
            jLabel9.setFont(font16);
        }
        ((Component)jLabel9).setForeground(new Color(-1));
        jLabel9.setOpaque(false);
        jLabel9.setText("Select Game Version:");
        jPanel8.add((Component)jLabel9, new GridConstraints(0, 0, 1, 3, 0, 0, 0, 0, null, null, null));
        this.skipBaseCheck = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setBackground(new Color(-15128227));
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.setFocusPainted(false);
        Font font17 = this.$$$getFont$$$("Exo 2", -1, -1, jCheckBox.getFont());
        if (font17 != null) {
            jCheckBox.setFont(font17);
        }
        ((Component)jCheckBox).setForeground(new Color(-1));
        jCheckBox.setLabel("Don't redownload existing core game files");
        jCheckBox.setText("Don't redownload existing core game files");
        jPanel8.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 3, 0, 0, 3, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        ((Component)jLabel10).setBackground(new Color(-15128227));
        Font font18 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel10.getFont());
        if (font18 != null) {
            jLabel10.setFont(font18);
        }
        ((Component)jLabel10).setForeground(new Color(-1));
        jLabel10.setOpaque(false);
        jLabel10.setText("Select DLC Packs:");
        jPanel7.add((Component)jLabel10, new GridConstraints(1, 1, 1, 2, 2, 0, 0, 0, null, null, null));
        this.installedList = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setFocusable(false);
        jPanel2.setOpaque(false);
        jPanel7.add((Component)jPanel2, new GridConstraints(0, 0, 3, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), "Installed Packs", 2, 1, this.$$$getFont$$$("Exo 2", -1, -1, jPanel2.getFont()), new Color(-1)));
        this.installedListMargin = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(5, 1, new Insets(4, 16, 4, 16), -1, -1, false, false));
        jPanel.setFocusable(false);
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.ipcBase = jLabel5 = new JLabel();
        Font font19 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel5.getFont());
        if (font19 != null) {
            jLabel5.setFont(font19);
        }
        ((Component)jLabel5).setForeground(new Color(-1));
        jLabel5.setHorizontalAlignment(2);
        jLabel5.setHorizontalTextPosition(11);
        jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel5.setText("Base Game");
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.ipcPatch1 = jLabel4 = new JLabel();
        Font font20 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel4.getFont());
        if (font20 != null) {
            jLabel4.setFont(font20);
        }
        ((Component)jLabel4).setForeground(new Color(-1));
        jLabel4.setHorizontalAlignment(2);
        jLabel4.setHorizontalTextPosition(11);
        jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel4.setText("Update v1.01");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.ipcPatch2 = jLabel3 = new JLabel();
        Font font21 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel3.getFont());
        if (font21 != null) {
            jLabel3.setFont(font21);
        }
        ((Component)jLabel3).setForeground(new Color(-1));
        jLabel3.setHorizontalAlignment(2);
        jLabel3.setHorizontalTextPosition(11);
        jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel3.setText("Update v1.04");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.ipcDlcHD = jLabel2 = new JLabel();
        Font font22 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel2.getFont());
        if (font22 != null) {
            jLabel2.setFont(font22);
        }
        ((Component)jLabel2).setForeground(new Color(-1));
        jLabel2.setHorizontalAlignment(2);
        jLabel2.setHorizontalTextPosition(11);
        jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel2.setText("HD Add-On Pack");
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.ipcDlcFury = jLabel = new JLabel();
        Font font23 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel.getFont());
        if (font23 != null) {
            jLabel.setFont(font23);
        }
        ((Component)jLabel).setForeground(new Color(-1));
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(11);
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel.setText("Fury Add-On Pack");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 0, 3, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.frameContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

