/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Ernie
implements ActionListener {
    public static final String gitapi = "https://git.worlio.com/api/v1/repos/bonkmaykr/firestar";
    public static final String changelog = "https://bonkmaykr.worlio.com/http/firestar/changelog.htm";
    private HttpURLConnection httpConn;
    private int contentLength;
    private InputStream inputStream;
    private JFrame frame;
    private JPanel frameContainer;
    private JEditorPane changelogDisplay;
    private JButton notnowbtn;
    private JButton surebtn;
    public boolean backgroundDone;
    private JFrame parent;

    public Ernie(final JFrame parent, boolean isManual) {
        this.$$$setupUI$$$();
        this.frame = new JFrame();
        this.backgroundDone = false;
        this.parent = parent;
        this.frame.setIconImage(Main.windowIcon);
        byte[] urlraw = this.getFile("https://git.worlio.com/api/v1/repos/bonkmaykr/firestar/releases?draft=false&pre-release=false");
        if (urlraw.length <= 0) {
            JOptionPane.showMessageDialog(this.frame, "Internal Error: Couldn't check for updates.", "Fatal Error", 0);
        } else {
            try {
                JSONArray releases = new JSONArray(new String(urlraw, Charset.forName("utf-8")));
                System.out.println("Updater: latest release is " + ((JSONObject)releases.get(0)).get("tag_name"));
                if (releases.length() >= 1 && (!Main.isNightly && !((JSONObject)releases.get(0)).get("tag_name").equals("tetsuo-1.3.1") || Main.isNightly && !((JSONObject)releases.get(0)).get("tag_name").equals("tetsuo-1.3.1"))) {
                    System.out.println("Updater: Your version is out of date.");
                    this.frame.add(this.frameContainer);
                    this.notnowbtn.addActionListener(this);
                    this.surebtn.addActionListener(this);
                    this.changelogDisplay.setEditable(false);
                    this.changelogDisplay.setPage(changelog);
                    this.changelogDisplay.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                    this.frame.setTitle("An update is available!");
                    this.frame.setSize(450, 400);
                    this.frame.setResizable(false);
                    this.frame.setLocationRelativeTo(parent);
                    this.frame.setAlwaysOnTop(true);
                    this.frame.setDefaultCloseOperation(0);
                    parent.setEnabled(false);
                    this.frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            parent.setEnabled(true);
                            e.getWindow().dispose();
                        }
                    });
                    this.frame.setVisible(true);
                } else {
                    System.out.println("Updater: No updates.");
                    if (isManual) {
                        JOptionPane.showMessageDialog(this.frame, "There are no updates at this time.", "Check for Updates", 1);
                    }
                }
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(Ernie.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.notnowbtn) {
            this.parent.setEnabled(true);
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.surebtn && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            String releasepage = "https://git.worlio.com/bonkmaykr/firestar/releases";
            try {
                Desktop.getDesktop().browse(new URI(releasepage));
                this.parent.setEnabled(true);
                this.frame.dispose();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.frame, "Couldn't open your web browser!\nYou can check out the latest release at the URL below:\n" + releasepage, "Error", 0);
            }
        }
    }

    byte[] getFile(String url) {
        try {
            URL fileURL = new URL(url);
            this.httpConn = (HttpURLConnection)fileURL.openConnection();
            int response = this.httpConn.getResponseCode();
            if (response != 200) {
                if (response == 404) {
                    throw new IOException("File missing from remote server.");
                }
                throw new IOException("Unexpected response; Server replied with " + response);
            }
            this.contentLength = this.httpConn.getContentLength();
            this.inputStream = this.httpConn.getInputStream();
            ErnieDownloader ed = new ErnieDownloader(this, url, this.httpConn.getContentLength());
            ed.doInBackground();
            while (!this.backgroundDone) {
            }
            this.inputStream.close();
            this.httpConn.disconnect();
            this.frame.dispose();
            return ed.output;
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this.frame, "Internal Error: URL given to Ernie is not valid.\nGet a programmer!", "Fatal Error", 0);
            this.frame.dispose();
            return new byte[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Error: " + e.getMessage(), "Fatal Error", 0);
            this.frame.dispose();
            return new byte[0];
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.frameContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 2, new Insets(10, 5, 5, 5), -1, -1, false, false));
        ((Component)jPanel).setBackground(new Color(-15128227));
        ((Component)jPanel).setForeground(new Color(-592129));
        JLabel jLabel = new JLabel();
        Font font = this.$$$getFont$$$("Exo 2", -1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        ((Component)jLabel).setForeground(new Color(-592129));
        jLabel.setText("A new update for Firestar is available!");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 0, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 1, new Insets(5, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-15128227));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-15128227));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.notnowbtn = jButton2 = new JButton();
        ((Component)jButton2).setBackground(new Color(-2271221));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        Font font2 = this.$$$getFont$$$("Exo 2", -1, -1, jButton2.getFont());
        if (font2 != null) {
            jButton2.setFont(font2);
        }
        ((Component)jButton2).setForeground(new Color(-657921));
        jButton2.setText("No Thanks");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 4, 2, 0, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        this.surebtn = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-2271221));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        Font font3 = this.$$$getFont$$$("Exo 2", -1, -1, jButton.getFont());
        if (font3 != null) {
            jButton.setFont(font3);
        }
        ((Component)jButton).setForeground(new Color(-592129));
        jButton.setText("Open in Browser");
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 8, 2, 0, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        Font font4 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel2.getFont());
        if (font4 != null) {
            jLabel2.setFont(font4);
        }
        ((Component)jLabel2).setForeground(new Color(-657921));
        jLabel2.setText("If you want to stay on this version,");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        Font font5 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel3.getFont());
        if (font5 != null) {
            jLabel3.setFont(font5);
        }
        ((Component)jLabel3).setForeground(new Color(-592129));
        jLabel3.setText("you can disable this notification in the Options.");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.changelogDisplay = jEditorPane = new JEditorPane();
        ((Component)jEditorPane).setBackground(new Color(-15128227));
        Font font6 = this.$$$getFont$$$("Exo 2", -1, -1, jEditorPane.getFont());
        if (font6 != null) {
            jEditorPane.setFont(font6);
        }
        ((Component)jEditorPane).setForeground(new Color(-592129));
        jScrollPane.setViewportView(jEditorPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.frameContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

