/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import javax.swing.SwingWorker;

class FozzieDownloader
extends SwingWorker<Void, Void> {
    private static final int BUFFER_SIZE = 4096;
    private String downloadURL;
    private String saveDirectory;
    private String saveName;
    private final Fozzie gui;
    private final long completeSize;

    public FozzieDownloader(Fozzie gui, String downloadURL, String saveDirectory, String saveName, long size) {
        this.gui = gui;
        this.downloadURL = downloadURL;
        this.saveDirectory = saveDirectory;
        this.saveName = saveName;
        this.completeSize = size;
    }

    @Override
    protected Void doInBackground() throws Exception {
        long downloadedSize = 0L;
        File downloadLocationDir = new File(this.saveDirectory);
        File downloadLocation = new File(this.saveDirectory + "/" + this.saveName);
        downloadLocationDir.mkdirs();
        if (!downloadLocation.isFile()) {
            downloadLocation.createNewFile();
        }
        BufferedInputStream in = new BufferedInputStream(new URL(this.downloadURL).openStream());
        FileOutputStream fos = new FileOutputStream(this.saveDirectory + "/" + this.saveName);
        BufferedOutputStream out = new BufferedOutputStream(fos, 1024);
        byte[] data = new byte[1024];
        int x = 0;
        while ((x = in.read(data, 0, 1024)) >= 0) {
            int progress = (int)((double)(downloadedSize += (long)x) / (double)this.completeSize * 100.0);
            this.gui.progressBar.setValue(progress);
            out.write(data, 0, x);
        }
        out.close();
        in.close();
        this.gui.backgroundDone = true;
        return null;
    }
}

