/*
 * Decompiled with CFR 0.152.
 */
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ReplacingInputStream
extends FilterInputStream {
    private Queue<Integer> inQueue = new LinkedList<Integer>();
    private Queue<Integer> outQueue = new LinkedList<Integer>();
    private final byte[] search;
    private final byte[] replacement;
    private boolean caseSensitive = true;

    public ReplacingInputStream(InputStream in, String search, String replacement) {
        super(in);
        this.search = search.getBytes();
        this.replacement = replacement.getBytes();
    }

    public ReplacingInputStream(InputStream in, String search, String replacement, boolean caseSensitive) {
        super(in);
        this.search = search.getBytes();
        this.replacement = replacement.getBytes();
        this.caseSensitive = caseSensitive;
    }

    private boolean isMatchFound() {
        Iterator iterator = this.inQueue.iterator();
        for (byte b : this.search) {
            if (!iterator.hasNext()) {
                return false;
            }
            Integer i = (Integer)iterator.next();
            if (this.caseSensitive && b != i) {
                return false;
            }
            if (Character.toLowerCase(b) == Character.toLowerCase(i.byteValue())) continue;
            return false;
        }
        return true;
    }

    private void readAhead() throws IOException {
        while (this.inQueue.size() < this.search.length) {
            int next = super.read();
            this.inQueue.offer(next);
            if (next != -1) continue;
            break;
        }
    }

    @Override
    public int read() throws IOException {
        while (this.outQueue.isEmpty()) {
            this.readAhead();
            if (this.isMatchFound()) {
                for (byte a : this.search) {
                    this.inQueue.remove();
                }
                for (byte b : this.replacement) {
                    this.outQueue.offer(Integer.valueOf(b));
                }
                continue;
            }
            this.outQueue.add(this.inQueue.remove());
        }
        return this.outQueue.remove();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }
}

