/*
 * Decompiled with CFR 0.152.
 */
import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Rizzo {
    private final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private Scanner scanner;
    private final int maxVer = 1;
    private int ver = 1;
    private String workingDir;

    public Rizzo(InputStream infile, String workingDir) throws FileNotFoundException, FirescriptFormatException {
        this.workingDir = !workingDir.endsWith("/") ? workingDir + "/" : workingDir;
        this.scanner = new Scanner(infile);
        this.parseScript(null);
    }

    private void parseScript(Object context) throws FirescriptFormatException {
        String line;
        while (this.scanner.hasNextLine() && ((line = this.scanner.nextLine().trim()).startsWith("#") || line.length() < 1 || this.parseArgs(Rizzo.translateCommandline(line), context))) {
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseArgs(String[] args, Object context) throws FirescriptFormatException {
        if (args.length <= 0) return true;
        if (context == null) {
            System.out.println("Parsing Command: " + Arrays.toString(args));
            if (args[0].equalsIgnoreCase("fscript")) {
                this.ver = Integer.parseInt(args[1]);
                if (this.ver <= 1) return true;
                throw new FirescriptFormatException(args[0], "script too new");
            }
            if (!args[0].equalsIgnoreCase("file")) throw new FirescriptFormatException("fscript", "command '" + args[0] + "' is unknown or used in inappropriate context");
            File newCtx = new File(this.workingDir + args[1]);
            System.out.println("Calling new parse: " + Arrays.toString(Arrays.copyOfRange(args, 2, args.length)));
            this.parseArgs(Arrays.copyOfRange(args, 2, args.length), newCtx);
            return true;
        }
        System.out.println("Parsing Command: " + Arrays.toString(args) + " using context: " + context.getClass().getName() + "@" + context.hashCode());
        if (args[0].equals("{")) {
            System.out.println("New context block: " + context.getClass().getName() + "@" + context.hashCode());
            this.parseScript(context);
            return true;
        }
        if (args[0].equals("}")) {
            System.out.println("Ending context block: " + context.getClass().getName() + "@" + context.hashCode());
            return false;
        }
        if (context instanceof File) {
            File file = (File)context;
            if (file.exists()) {
                if (args[0].equalsIgnoreCase("delete")) {
                    System.out.println("Deleting: " + file.getPath());
                    if (!file.getAbsolutePath().startsWith(this.workingDir)) return true;
                    if (file.isDirectory()) {
                        Main.deleteDir(file);
                        return true;
                    } else {
                        file.delete();
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("xml")) {
                    try {
                        DocumentBuilder docBuilder = this.docFactory.newDocumentBuilder();
                        ReplacingInputStream ris = new ReplacingInputStream(new ReplacingInputStream(new ReplacingInputStream(new FileInputStream(file), "\r\n", ""), "&", "&amp;"), "\n", "&#10;");
                        Document doc = docBuilder.parse(ris);
                        this.parseArgs(Arrays.copyOfRange(args, 1, args.length), doc);
                        try {
                            FileOutputStream output = new FileOutputStream(file);
                            Transformer transformer = TransformerFactory.newInstance().newTransformer();
                            StreamResult result = new StreamResult(new StringWriter());
                            DOMSource source = new DOMSource(doc);
                            transformer.setOutputProperty("method", "html");
                            transformer.transform(source, result);
                            String xmlString = StringEscapeUtils.unescapeHtml4(result.getWriter().toString());
                            try (PrintStream ps = new PrintStream(output);){
                                ps.print(xmlString);
                                return true;
                            }
                        }
                        catch (TransformerException ex) {
                            Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, null, ex);
                            return true;
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException ex) {
                        Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, "This usually means there's non-standard formatting from the game developer which your FSCRIPT does not account for.", ex);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("str") || args[0].equalsIgnoreCase("xstr")) {
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        ByteArrayInputStream bais = new ByteArrayInputStream(fis.readAllBytes());
                        fis.close();
                        FileOutputStream fos = new FileOutputStream(file);
                        if (args[1].equalsIgnoreCase("append")) {
                            bais.transferTo(fos);
                            for (int s = 0; s < args[2].length(); ++s) {
                                char c = args[2].charAt(s);
                                fos.write(c);
                            }
                        } else if (args[1].equalsIgnoreCase("replace") || args[1].equalsIgnoreCase("delete")) {
                            String replacement = "";
                            if (args[1].equalsIgnoreCase("replace")) {
                                replacement = args[3];
                            }
                            ReplacingInputStream ris = args[0].equalsIgnoreCase("xstr") ? new ReplacingInputStream(bais, args[2], replacement, false) : new ReplacingInputStream(bais, args[2], replacement);
                            ris.transferTo(fos);
                            ris.close();
                        }
                        fos.flush();
                        fos.close();
                        return true;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("binedit")) {
                    int offset = Integer.parseInt(args[1]);
                    String bytes = args[2];
                    if (bytes.length() % 2 != 0) {
                        throw new FirescriptFormatException(args[0], "invalid length of bytes");
                    }
                    try {
                        byte[] ba;
                        try (FileInputStream fis = new FileInputStream(file);){
                            ba = fis.readAllBytes();
                        }
                        if (offset >= ba.length) {
                            throw new FirescriptFormatException(args[0], "offset is larger than file size");
                        }
                        byte[] in = HexFormat.of().parseHex(bytes);
                        System.arraycopy(in, 0, ba, offset, in.length);
                        try (FileOutputStream fos = new FileOutputStream(file);){
                            fos.write(ba);
                            fos.flush();
                            return true;
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return true;
                }
                if (!args[0].equalsIgnoreCase("patch")) throw new FirescriptFormatException("file", "command '" + args[0] + "' is unknown or used in inappropriate context");
                try {
                    List<String> original = Files.readAllLines(file.toPath());
                    File patchFile = new File(this.workingDir + args[1]);
                    if (!patchFile.exists()) {
                        throw new FirescriptFormatException(args[0], "patch file doesn't exist");
                    }
                    List<String> patched = Files.readAllLines(patchFile.toPath());
                    Patch<String> patch = UnifiedDiffUtils.parseUnifiedDiff(patched);
                    List<String> result = DiffUtils.patch(original, patch);
                    try (FileWriter fileWriter = new FileWriter(file);){
                        for (String str : result) {
                            fileWriter.write(str + "\r\n");
                        }
                        return true;
                    }
                }
                catch (FirescriptFormatException | PatchFailedException | IOException ex) {
                    Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, null, ex);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("xml")) {
                System.out.println("fscript: XML called but file does not exist. Using placebo...");
                try {
                    DocumentBuilder docBuilder = this.docFactory.newDocumentBuilder();
                    this.parseArgs(Arrays.copyOfRange(args, 1, args.length), docBuilder.newDocument());
                    return true;
                }
                catch (ParserConfigurationException ex1) {
                    Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, null, ex1);
                    throw new FirescriptFormatException("xml", "critical document failure");
                }
            } else {
                System.out.println("fscript: file context not found, skipping.");
            }
            return true;
        }
        if (context instanceof Document) {
            Document document = (Document)context;
            if (document.hasChildNodes()) {
                if (args[0].equalsIgnoreCase("modify")) {
                    Element elem = (Element)this.traverse(document, args[1]);
                    this.parseArgs(Arrays.copyOfRange(args, 2, args.length), elem);
                    return true;
                } else if (args[0].equalsIgnoreCase("create")) {
                    String newTag = args[1].substring(args[1].lastIndexOf(".") + 1);
                    String newID = "";
                    if (newTag.contains("#")) {
                        newID = newTag.substring(newTag.indexOf("#") + 1);
                        newTag = newTag.substring(0, newTag.indexOf("#"));
                    }
                    Element newElem = document.createElement(newTag);
                    if (newID != null && newID.length() > 0) {
                        newElem.setAttribute("id", newID);
                    }
                    this.traverse(document, args[1].substring(0, args[1].lastIndexOf("."))).appendChild(newElem);
                    this.parseArgs(Arrays.copyOfRange(args, 2, args.length), newElem);
                    return true;
                } else if (args[0].equalsIgnoreCase("delete")) {
                    Element elem = (Element)this.traverse(document, args[1]);
                    elem.getParentNode().removeChild(elem);
                    return true;
                } else {
                    if (!args[0].equalsIgnoreCase("merge")) throw new FirescriptFormatException("xml", "command '" + args[0] + "' is unknown or used in inappropriate context");
                    try {
                        DocumentBuilder docBuilder = this.docFactory.newDocumentBuilder();
                        ReplacingInputStream ris = new ReplacingInputStream(new ReplacingInputStream(new ReplacingInputStream(new FileInputStream(new File(this.workingDir + args[1])), "\r\n", ""), "&", "&amp;"), "\n", "&#10;");
                        Document outDoc = docBuilder.parse(ris);
                        NamedNodeMap nnm = outDoc.getDocumentElement().getAttributes();
                        for (int x = 0; x < nnm.getLength(); ++x) {
                            Attr importedNode = (Attr)document.importNode(nnm.item(x), true);
                            document.getDocumentElement().setAttributeNodeNS(importedNode);
                        }
                        NodeList cn = outDoc.getDocumentElement().getChildNodes();
                        for (int x = 0; x < cn.getLength(); ++x) {
                            Node importedNode = document.importNode(cn.item(x), true);
                            document.getDocumentElement().appendChild(importedNode);
                        }
                        return true;
                    }
                    catch (IOException | ParserConfigurationException | SAXException ex) {
                        Logger.getLogger(Rizzo.class.getName()).log(Level.SEVERE, "This usually means there's non-standard formatting from the game developer which your FSCRIPT does not account for.", ex);
                        return true;
                    }
                }
            } else {
                System.out.println("fscript: XML document has no child nodes. Skipping...");
                this.parseArgs(Arrays.copyOfRange(args, 1, args.length), document);
            }
            return true;
        } else {
            if (!(context instanceof Element)) throw new FirescriptFormatException("context is unknown");
            Element element = (Element)context;
            if (args[0].equalsIgnoreCase("set")) {
                if (args[1].equalsIgnoreCase("attribute")) {
                    element.setAttribute(args[2], args[3].replace("\\n", "&#10;"));
                    return true;
                } else {
                    if (!args[1].equalsIgnoreCase("value")) return true;
                    element.setNodeValue(args[2]);
                }
                return true;
            } else if (args[0].equalsIgnoreCase("create")) {
                String finalTag = args[1];
                String path = "";
                if (finalTag.lastIndexOf(".") > 0) {
                    path = args[1].substring(0, finalTag.lastIndexOf("."));
                    finalTag = args[1].substring(finalTag.lastIndexOf(".") + 1);
                }
                String id = "";
                String name = "";
                if (finalTag.contains("#")) {
                    id = finalTag.substring(finalTag.indexOf("#") + 1);
                    finalTag = finalTag.substring(0, finalTag.indexOf("#"));
                } else if (finalTag.contains("$")) {
                    name = finalTag.substring(finalTag.indexOf("$") + 1);
                    finalTag = finalTag.substring(0, finalTag.indexOf("$"));
                }
                Element finalElem = element.getOwnerDocument().createElement(finalTag);
                if (id != null && id.length() > 0) {
                    finalElem.setAttribute("id", id);
                }
                if (name != null && name.length() > 0) {
                    finalElem.setAttribute("name", name);
                }
                this.traverse(element, path).appendChild(finalElem);
                this.parseArgs(Arrays.copyOfRange(args, 2, args.length), finalElem);
                return true;
            } else {
                if (!args[0].equalsIgnoreCase("create-at")) throw new FirescriptFormatException("xml", "unknown element command '" + args[0] + "'");
                int index = Integer.parseInt(args[1]);
                String finalTag = args[2];
                String id = "";
                String name = "";
                if (finalTag.contains("#")) {
                    id = finalTag.substring(finalTag.indexOf("#") + 1);
                    finalTag = finalTag.substring(0, finalTag.indexOf("#"));
                } else if (finalTag.contains("$")) {
                    name = finalTag.substring(finalTag.indexOf("$") + 1);
                    finalTag = finalTag.substring(0, finalTag.indexOf("$"));
                }
                Element finalElem = element.getOwnerDocument().createElement(finalTag);
                if (id != null && id.length() > 0) {
                    finalElem.setAttribute("id", id);
                }
                if (name != null && name.length() > 0) {
                    finalElem.setAttribute("name", name);
                }
                element.insertBefore(finalElem, element.getChildNodes().item(index));
                this.parseArgs(Arrays.copyOfRange(args, 3, args.length), finalElem);
            }
        }
        return true;
    }

    private Node traverse(Node owner, String selector) throws FirescriptFormatException {
        if (selector == null || selector.length() == 0 || owner == null) {
            return owner;
        }
        String[] elems = selector.split("\\.");
        Node parent = owner;
        for (String tag : elems) {
            Node newParent = null;
            int index = 0;
            if (tag.contains("[")) {
                index = Integer.parseInt(tag.substring(tag.indexOf("[") + 1, tag.lastIndexOf("]")));
                tag = tag.substring(0, tag.indexOf("["));
            }
            String id = "";
            if (tag.contains("#")) {
                id = tag.substring(tag.indexOf("#") + 1);
                tag = tag.substring(0, tag.indexOf("#"));
            }
            String name = "";
            if (tag.contains("$")) {
                name = tag.substring(tag.indexOf("$") + 1);
                tag = tag.substring(0, tag.indexOf("$"));
            }
            if (id.length() > 0) {
                if (parent instanceof Document) {
                    Document document = (Document)parent;
                    ns = document.getElementsByTagName(tag);
                } else {
                    ns = ((Element)parent).getElementsByTagName(tag);
                }
                for (i = 0; i < ns.getLength(); ++i) {
                    n = ns.item(i);
                    if (n.getNodeName().equals("#text") || !((Element)n).getAttribute("id").equals(id)) continue;
                    newParent = (Element)n;
                    break;
                }
            } else if (name.length() > 0) {
                if (parent instanceof Document) {
                    Document document = (Document)parent;
                    ns = document.getChildNodes();
                } else {
                    ns = ((Element)parent).getChildNodes();
                }
                for (i = 0; i < ns.getLength(); ++i) {
                    n = ns.item(i);
                    if (n instanceof Comment || n.getNodeName().equals("#text") || !((Element)n).getAttribute("name").equals(name)) continue;
                    newParent = (Element)n;
                    break;
                }
            } else if (parent instanceof Document) {
                Document document = (Document)parent;
                newParent = document.getElementsByTagName(tag).item(index);
            } else {
                newParent = ((Element)parent).getElementsByTagName(tag).item(index);
            }
            if (newParent == null) {
                throw new FirescriptFormatException("xml: selector is invalid");
            }
            parent = newParent;
        }
        return parent;
    }

    private static String[] translateCommandline(String line) throws FirescriptFormatException {
        if (line == null || line.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        boolean lastTokenWasEscaped = false;
        block10: for (int i = 0; i < line.length(); ++i) {
            int nextTok = line.charAt(i);
            switch (state) {
                case 1: {
                    if (nextTok == 92) {
                        lastTokenWasEscaped = true;
                        continue block10;
                    }
                    if (nextTok == 39 && !lastTokenWasEscaped) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block10;
                    }
                    if (lastTokenWasEscaped) {
                        if (nextTok == 116) {
                            nextTok = 9;
                        }
                        if (nextTok == 98) {
                            nextTok = 8;
                        }
                        if (nextTok == 110) {
                            nextTok = 10;
                        }
                        if (nextTok == 114) {
                            nextTok = 13;
                        }
                        if (nextTok == 102) {
                            nextTok = 12;
                        }
                    }
                    current.append((char)nextTok);
                    lastTokenWasEscaped = false;
                    continue block10;
                }
                case 2: {
                    if (nextTok == 92) {
                        lastTokenWasEscaped = true;
                        continue block10;
                    }
                    if (nextTok == 34 && !lastTokenWasEscaped) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block10;
                    }
                    if (lastTokenWasEscaped) {
                        if (nextTok == 116) {
                            nextTok = 9;
                        }
                        if (nextTok == 98) {
                            nextTok = 8;
                        }
                        if (nextTok == 110) {
                            nextTok = 10;
                        }
                        if (nextTok == 114) {
                            nextTok = 13;
                        }
                        if (nextTok == 102) {
                            nextTok = 12;
                        }
                    }
                    current.append((char)nextTok);
                    lastTokenWasEscaped = false;
                    continue block10;
                }
                default: {
                    switch (nextTok) {
                        case 92: {
                            lastTokenWasEscaped = true;
                            break;
                        }
                        case 39: {
                            state = 1;
                            break;
                        }
                        case 34: {
                            state = 2;
                            break;
                        }
                        case 32: {
                            if (lastTokenWasEscaped || !lastTokenHasBeenQuoted && current.length() == 0) break;
                            result.add(current.toString());
                            current.setLength(0);
                            break;
                        }
                        default: {
                            if (lastTokenWasEscaped) {
                                if (nextTok == 116) {
                                    nextTok = 9;
                                }
                                if (nextTok == 98) {
                                    nextTok = 8;
                                }
                                if (nextTok == 110) {
                                    nextTok = 10;
                                }
                                if (nextTok == 114) {
                                    nextTok = 13;
                                }
                                if (nextTok == 102) {
                                    nextTok = 12;
                                }
                                lastTokenWasEscaped = false;
                            }
                            current.append((char)nextTok);
                        }
                    }
                    lastTokenHasBeenQuoted = false;
                }
            }
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new FirescriptFormatException("unbalanced quotes in " + line);
        }
        return result.toArray(new String[result.size()]);
    }
}

