/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class Waldorf
implements ActionListener {
    private JFrame frame;
    private JPanel frameContainer;
    private JButton okbtn;
    private JButton cancelbtn;
    private JLabel fOutpath;
    private JButton resetbtn;
    private JButton bOpenFolder;
    private JButton dwnSDKbtn;
    private JButton dwnARCbtn;
    private JButton fOutpathChangebtn;
    private JCheckBox checkUpdatesToggle;
    private JButton bDelArcs;
    MissPiggy invoker;
    private String tOutPath;

    public Waldorf() {
        this.$$$setupUI$$$();
        this.frame = new JFrame();
        this.tOutPath = Main.outpath;
    }

    public void Action(MissPiggy inv) {
        this.invoker = inv;
        this.frame.add(this.frameContainer);
        this.frame.setIconImage(Main.windowIcon);
        this.frame.setSize(600, 300);
        this.frame.setMinimumSize(new Dimension(200, 100));
        this.frame.setTitle("Options");
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setLayout(new GridLayout());
        this.frame.setLocationRelativeTo(inv.frame);
        this.frame.setAlwaysOnTop(true);
        this.cancelbtn.addActionListener(this);
        this.okbtn.addActionListener(this);
        this.resetbtn.addActionListener(this);
        this.bOpenFolder.addActionListener(this);
        this.bDelArcs.addActionListener(this);
        this.dwnARCbtn.addActionListener(this);
        this.dwnSDKbtn.addActionListener(this);
        this.fOutpathChangebtn.addActionListener(this);
        this.updateDOutpath(Main.outpath);
        this.checkUpdatesToggle.setSelected(Main.checkUpdates);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Waldorf.this.invoker.frame.setEnabled(true);
                e.getWindow().dispose();
            }
        });
    }

    private void updateDOutpath(String path) {
        Object s = path;
        if (((String)s).startsWith(System.getProperty("user.home"))) {
            s = "~" + ((String)s).substring(System.getProperty("user.home").length());
        }
        if (((String)s).length() > 50) {
            s = ((String)s).substring(0, Math.min(path.length(), 46)) + "...";
            this.fOutpath.setToolTipText(path);
        } else {
            this.fOutpath.setToolTipText(null);
        }
        this.fOutpath.setText((String)s);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelbtn) {
            this.invoker.frame.setEnabled(true);
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.okbtn) {
            Main.outpath = this.tOutPath;
            Main.checkUpdates = this.checkUpdatesToggle.isSelected();
            Main.writeConf();
            Main.loadConf();
            this.invoker.frame.setEnabled(true);
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.resetbtn) {
            int result = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to redo the initial setup?", "Restore Default Settings", 0, 2);
            if (result == 0) {
                System.out.println("Restoring default settings");
                new File(System.getProperty("user.home") + "/.firestar/firestar.conf").delete();
                int result2 = JOptionPane.showConfirmDialog(this.frame, "Firestar will now close.", "Restore Default Settings", -1, 1);
                if (result2 == 0) {
                    System.exit(0);
                }
            }
        } else if (actionEvent.getSource() == this.bOpenFolder) {
            try {
                Desktop.getDesktop().open(new File(Main.inpath));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (actionEvent.getSource() == this.bDelArcs) {
            int result = JOptionPane.showConfirmDialog(this.frame, "All existing PSARC dumps will be deleted.\nDo you want to continue?", "Delete PSARCs", 0, 2);
            if (result == 1) {
                return;
            }
            System.out.println("User requested arc wipe, deleting existing PSARCs");
            new File(Main.inpath + "data.psarc").delete();
            new File(Main.inpath + "data1.psarc").delete();
            new File(Main.inpath + "data2.psarc").delete();
            new File(Main.inpath + "dlc1.psarc").delete();
            new File(Main.inpath + "dlc2.psarc").delete();
            JOptionPane.showMessageDialog(this.frame, "PSARC files purged.", "Delete PSARCs", 1);
        } else if (actionEvent.getSource() == this.dwnARCbtn) {
            if (!new File(Main.inpath + "pkg2zip.exe").exists() || !new File(Main.inpath + "psvpfsparser.exe").exists()) {
                JOptionPane.showMessageDialog(this.frame, "Your decryption tools are missing.\nPlease select \"Get Dependencies\" in the Options menu.", "Error", 0);
                return;
            }
            new Bert(this.invoker.frame);
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.dwnSDKbtn) {
            Thread downloaderPopupThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Main.downloadDependenciesBeforeSetVisible(Waldorf.this.invoker.frame);
                    Waldorf.this.invoker.frame.setEnabled(true);
                }
            });
            downloaderPopupThread.start();
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.fOutpathChangebtn) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            int result = fileChooser.showOpenDialog(this.frame);
            if (result == 0 && fileChooser.getSelectedFile().isDirectory()) {
                this.tOutPath = fileChooser.getSelectedFile().getAbsolutePath() + "/";
                this.updateDOutpath(this.tOutPath);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JCheckBox jCheckBox;
        JButton jButton6;
        JLabel jLabel;
        JButton jButton7;
        JButton jButton8;
        JPanel jPanel;
        this.frameContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(7, 3, new Insets(10, 25, 10, 25), -1, -1, false, false));
        ((Component)jPanel).setBackground(new Color(-15128227));
        ((Component)jPanel).setForeground(new Color(-1));
        jPanel.setMaximumSize(new Dimension(50, 100));
        jPanel.setMinimumSize(new Dimension(50, 100));
        jPanel.setPreferredSize(new Dimension(50, 100));
        JLabel jLabel2 = new JLabel();
        Font font = this.$$$getFont$$$("Exo 2", -1, -1, jLabel2.getFont());
        if (font != null) {
            jLabel2.setFont(font);
        }
        ((Component)jLabel2).setForeground(new Color(-1));
        jLabel2.setText("Mod Export Path");
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        Font font2 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel3.getFont());
        if (font2 != null) {
            jLabel3.setFont(font2);
        }
        ((Component)jLabel3).setForeground(new Color(-1));
        jLabel3.setText(".firestar Folder");
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 3, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        Font font3 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel4.getFont());
        if (font3 != null) {
            jLabel4.setFont(font3);
        }
        ((Component)jLabel4).setForeground(new Color(-1));
        jLabel4.setText("Downloads");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(3, 5, 3, 5), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-15128227));
        ((Component)jPanel2).setForeground(new Color(-1));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), null, 0, 0, this.$$$getFont$$$("Exo 2", -1, -1, jPanel2.getFont()), new Color(-1)));
        this.dwnSDKbtn = jButton8 = new JButton();
        ((Component)jButton8).setBackground(new Color(-2271221));
        jButton8.setBorderPainted(false);
        jButton8.setFocusPainted(false);
        Font font4 = this.$$$getFont$$$("Exo 2", -1, -1, jButton8.getFont());
        if (font4 != null) {
            jButton8.setFont(font4);
        }
        ((Component)jButton8).setForeground(new Color(-1));
        jButton8.setText("Get Dependencies");
        jPanel2.add((Component)jButton8, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.dwnARCbtn = jButton7 = new JButton();
        ((Component)jButton7).setBackground(new Color(-2271221));
        jButton7.setBorderPainted(false);
        jButton7.setFocusPainted(false);
        Font font5 = this.$$$getFont$$$("Exo 2", -1, -1, jButton7.getFont());
        if (font5 != null) {
            jButton7.setFont(font5);
        }
        ((Component)jButton7).setForeground(new Color(-1));
        jButton7.setText("Auto-Download PSARCs");
        jPanel2.add((Component)jButton7, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel.add((Component)jPanel3, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 3, null, null, new Dimension(500, -1)));
        this.fOutpath = jLabel = new JLabel();
        Font font6 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel.getFont());
        if (font6 != null) {
            jLabel.setFont(font6);
        }
        ((Component)jLabel).setForeground(new Color(-1));
        jLabel.setText("Deploys Go Here");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.fOutpathChangebtn = jButton6 = new JButton();
        ((Component)jButton6).setBackground(new Color(-2271221));
        jButton6.setBorderPainted(false);
        jButton6.setFocusPainted(false);
        Font font7 = this.$$$getFont$$$("Exo 2", -1, -1, jButton6.getFont());
        if (font7 != null) {
            jButton6.setFont(font7);
        }
        ((Component)jButton6).setForeground(new Color(-1));
        jButton6.setText("Change");
        jPanel3.add((Component)jButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checkUpdatesToggle = jCheckBox = new JCheckBox();
        jCheckBox.setFocusPainted(false);
        Font font8 = this.$$$getFont$$$("Exo 2", -1, -1, jCheckBox.getFont());
        if (font8 != null) {
            jCheckBox.setFont(font8);
        }
        ((Component)jCheckBox).setForeground(new Color(-1));
        jCheckBox.setLabel("Automatically check for updates on startup");
        jCheckBox.setOpaque(false);
        jCheckBox.setRolloverEnabled(false);
        jCheckBox.setText("Automatically check for updates on startup");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 1, new Insets(3, 5, 3, 5), -1, -1, false, false));
        ((Component)jPanel4).setBackground(new Color(-15128227));
        ((Component)jPanel4).setForeground(new Color(-1));
        jPanel4.setOpaque(false);
        jPanel.add((Component)jPanel4, new GridConstraints(1, 1, 3, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), null, 0, 0, this.$$$getFont$$$("Exo 2", -1, -1, jPanel4.getFont()), new Color(-1)));
        this.bOpenFolder = jButton5 = new JButton();
        ((Component)jButton5).setBackground(new Color(-2271221));
        jButton5.setBorderPainted(false);
        jButton5.setFocusPainted(false);
        Font font9 = this.$$$getFont$$$("Exo 2", -1, -1, jButton5.getFont());
        if (font9 != null) {
            jButton5.setFont(font9);
        }
        ((Component)jButton5).setForeground(new Color(-1));
        jButton5.setLabel("Browse");
        jButton5.setText("Browse");
        jPanel4.add((Component)jButton5, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.bDelArcs = jButton4 = new JButton();
        ((Component)jButton4).setBackground(new Color(-2271221));
        jButton4.setBorderPainted(false);
        jButton4.setFocusPainted(false);
        Font font10 = this.$$$getFont$$$("Exo 2", -1, -1, jButton4.getFont());
        if (font10 != null) {
            jButton4.setFont(font10);
        }
        ((Component)jButton4).setForeground(new Color(-1));
        jButton4.setLabel("Delete PSARCs");
        jButton4.setText("Delete PSARCs");
        jPanel4.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setOpaque(false);
        jPanel.add((Component)jPanel5, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.cancelbtn = jButton3 = new JButton();
        ((Component)jButton3).setBackground(new Color(-2271221));
        jButton3.setBorderPainted(false);
        jButton3.setFocusPainted(false);
        Font font11 = this.$$$getFont$$$("Exo 2", -1, -1, jButton3.getFont());
        if (font11 != null) {
            jButton3.setFont(font11);
        }
        ((Component)jButton3).setForeground(new Color(-1));
        jButton3.setText("Cancel");
        jPanel5.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 0, 1, 0, new Dimension(100, -1), new Dimension(200, -1), new Dimension(200, -1)));
        this.resetbtn = jButton2 = new JButton();
        ((Component)jButton2).setBackground(new Color(-2271221));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        Font font12 = this.$$$getFont$$$("Exo 2", -1, -1, jButton2.getFont());
        if (font12 != null) {
            jButton2.setFont(font12);
        }
        ((Component)jButton2).setForeground(new Color(-1));
        jButton2.setText("Restore Defaults");
        jPanel5.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 0, 1, 0, new Dimension(100, -1), new Dimension(200, -1), new Dimension(200, -1)));
        this.okbtn = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-2271221));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        Font font13 = this.$$$getFont$$$("Exo 2", -1, -1, jButton.getFont());
        if (font13 != null) {
            jButton.setFont(font13);
        }
        ((Component)jButton).setForeground(new Color(-1));
        jButton.setText("Save");
        jPanel5.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 0, 1, 0, new Dimension(100, -1), new Dimension(200, -1), new Dimension(200, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.frameContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

