/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Main {
    public static String vstr = "Release 1.3.1";
    public static final String vcode = "Tetsuo";
    public static final String vtag = "tetsuo-1.3.1";
    public static final int vint = 1;
    public static boolean isNightly = false;
    public static final String vtagPrevious = "tetsuo-1.3.1";
    public static String dateOfCompile = null;
    public static String outpath = System.getProperty("user.home") + "/.firestar/out/";
    public static final String inpath = System.getProperty("user.home") + "/.firestar/";
    public static boolean repatch;
    public static boolean windows;
    public static int confvint;
    public static boolean checkUpdates;
    public static List<Mod> Mods;
    public static Font fExo2;
    public static BufferedImage windowIcon;

    public static void main(String[] args) throws InterruptedException {
        if (Main.class.getResource("/jenkinsVersionString") != null) {
            System.out.println("=== This is a NIGHTLY BUILD! ===\n");
            try {
                vstr = "Nightly " + IOUtils.toString(Main.class.getResourceAsStream("/jenkinsVersionString"), StandardCharsets.UTF_8);
                dateOfCompile = IOUtils.toString(Main.class.getResourceAsStream("/jenkinsBuildDate"), StandardCharsets.UTF_8);
                System.out.println("Compiled on " + dateOfCompile);
                isNightly = true;
            }
            catch (Exception e) {
                System.out.println("ERROR: Something went wrong trying to get the autobuild information! defaulting to Release values\n\n");
                isNightly = false;
            }
        }
        System.out.printf("FIRESTAR MOD MANAGER for WipEout 2048\n" + vstr + " (codename Tetsuo) major 1\nJVM host appears to be " + System.getProperty("os.name") + "\nRunning from " + System.getProperty("user.dir") + "\nCopyright (C) 2025 Canithesis Interactive\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see https://www.gnu.org/licenses/.\n\n\n\n", new Object[0]);
        new Beaker();
        try {
            fExo2 = Font.createFont(0, Main.class.getResourceAsStream("/exo2.ttf"));
        }
        catch (Exception e) {
            System.out.println("Font \"Exo 2\" is missing!");
            fExo2 = new Font("Arial", 0, 12);
        }
        try {
            windowIcon = ImageIO.read(Main.class.getResourceAsStream("/titleIcon.png"));
        }
        catch (IOException e) {
            System.out.println("ERROR: Failed to find titleIcon.png. Window will not have an icon.");
        }
        File fConf = new File(System.getProperty("user.home") + "/.firestar/firestar.conf");
        if (!fConf.isFile()) {
            System.out.println("No configuration was found. Starting the initial setup");
            new WilkinsCoffee().setup();
        } else {
            new MissPiggy().Action();
        }
    }

    public static void writeConf() {
        JSONObject container = new JSONObject();
        container.put("version", 1);
        container.put("2048path", outpath);
        container.put("HDpath", "TODO");
        container.put("safemode", repatch);
        container.put("isWin32", windows);
        container.put("checkUpdates", checkUpdates);
        container.put("currentPlaylist", "TODO");
        try {
            Files.write(Paths.get(System.getProperty("user.home") + "/.firestar/firestar.conf", new String[0]), container.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadConf() {
        try {
            JSONObject container = new JSONObject(new String(Files.readAllBytes(Paths.get(System.getProperty("user.home") + "/.firestar/firestar.conf", new String[0]))));
            System.out.println(container.toString());
            confvint = (Integer)container.get("version");
            outpath = container.get("2048path").toString();
            repatch = (Boolean)container.get("safemode");
            windows = (Boolean)container.get("isWin32");
            try {
                checkUpdates = (Boolean)container.get("checkUpdates");
            }
            catch (JSONException e) {
                checkUpdates = true;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR: Failed to load firestar.conf");
            System.out.println(e.getMessage());
        }
    }

    public static void loadConf(MissPiggy w) {
        try {
            JSONObject container = new JSONObject(new String(Files.readAllBytes(Paths.get(System.getProperty("user.home") + "/.firestar/firestar.conf", new String[0]))));
            System.out.println(container.toString());
            confvint = (Integer)container.get("version");
            outpath = container.get("2048path").toString();
            repatch = (Boolean)container.get("safemode");
            windows = (Boolean)container.get("isWin32");
            try {
                checkUpdates = (Boolean)container.get("checkUpdates");
            }
            catch (JSONException e) {
                checkUpdates = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(w.frame, "Firestar couldn't load your config file. Tread lightly.\n\n" + e.getMessage(), "Critical Error", 0);
            System.out.println("ERROR: Failed to load firestar.conf");
            System.out.println(e.getMessage());
        }
    }

    public static void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                Main.deleteDir(f);
            }
        }
        file.delete();
    }

    public static void downloadDependenciesBeforeSetVisible(JFrame invoker) {
        invoker.setVisible(false);
        Main.downloadDependencies();
        invoker.setVisible(true);
        confvint = 1;
        Main.writeConf();
    }

    public static boolean downloadDependencies() {
        boolean downloader = new Fozzie().DownloadFile("https://bonkmaykr.worlio.com/http/firestar/fire13.zip", System.getProperty("user.home") + "/.firestar/", "firesdk.zip", "Firestar dependencies");
        if (!downloader) {
            return false;
        }
        String expectedMD5Hash = "306807955266724172476879569959042600238";
        String downloadedMD5Hash = "";
        try {
            downloadedMD5Hash = new BigInteger(1, MessageDigest.getInstance("MD5").digest(Files.readAllBytes(Paths.get(inpath + "firesdk.zip", new String[0])))).toString();
        }
        catch (Exception e) {
            System.out.println("ERROR: Failed to download PSARC tool due to an internal problem.\n" + e.getMessage());
            JOptionPane.showMessageDialog(null, "The file failed to download.\nPlease check your network connection and try again.\n\n" + e.getMessage(), "Download Failed", 2);
        }
        if (!downloadedMD5Hash.equals("306807955266724172476879569959042600238")) {
            System.out.println("ERROR: Downloaded PSARC tool is invalid. Check your network connection and ensure the file is not corrupt or infected.");
            JOptionPane.showMessageDialog(null, "The downloaded file failed a security check.\nPlease ensure your network connection is stable.\n\nIf this issue persists, send an email to tech support\nat bonkmaykr@screwgravity.net.", "Download Cancelled", 2);
            return false;
        }
        ZipFile sdk = new ZipFile(System.getProperty("user.home") + "/.firestar/firesdk.zip");
        try {
            sdk.extractAll(System.getProperty("user.home") + "/.firestar/");
        }
        catch (ZipException e) {
            JOptionPane.showMessageDialog(new JFrame(), e.getMessage(), "Critical Error", 0);
            System.out.println(e.getMessage());
            return false;
        }
        sdk.getFile().delete();
        JOptionPane.showMessageDialog(null, "All remote dependencies satisfied.", "Download Completed", 1);
        return true;
    }

    public static Process exec(String[] cmd, String cwd) throws IOException {
        Process p;
        if (!windows) {
            String[] pcmd = new String[cmd.length + 1];
            pcmd[0] = "wine";
            System.arraycopy(cmd, 0, pcmd, 1, cmd.length);
            p = Runtime.getRuntime().exec(pcmd, null, new File(cwd));
        } else {
            p = Runtime.getRuntime().exec(cmd, null, new File(cwd.replace("/", "\\")));
        }
        return p;
    }

    public static void printProcessLogToStdOut(Process p) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (Exception e) {
            return;
        }
    }

    static {
        confvint = 1;
        checkUpdates = true;
        Mods = new ArrayList<Mod>();
    }

    public class Mod {
        public String path;
        public int version = 1;
        public int priority = 0;
        public String friendlyName;
        public String description = "";
        public String game;
        public int loaderversion = 0;
        public String author;
        public boolean enabled = true;
        public List<String> requires = new ArrayList<String>();
        public List<String> extracts = new ArrayList<String>();
    }

    public static enum ArcKey {
        BASE("KO5ifR1dQ+eHBlgi6TI0Bdkf7hng6h8aYmRgYuHkCLQNn/9ufV+01fmzjNSmwuVHnO4dEBuN8cENACqVFcgA"),
        FIRST("KO5ifR1dQ+eHBlgi6TI0Bdkf7hng6h8aYmRgYuHkCLQNn/9ufV+01fmzjNSmwuVHnO4dEBuN8cENACqVFcgA"),
        LATEST("KO5ifR1dQ+eHBlgi6TI0Bdkf7hng6h8aYmRgYuHkCLQNn/9ufV+01fmzjNSmwuVHnO4dEBuN8cENACqVFcgA"),
        ADDON_HD("KO5ifR1dQ+eHBlgi6TI0Bdnv4uNsGG5kYGIR4Ojs7ejuis9/anXfuudVNvzgdu+9z1z+asJojA9uAACgRhTl"),
        ADDON_HD_FURY("KO5ifR1dQ+eHBlgi6TI0Bdnv4uNsFG5kYGIR4Ojs7ejuis9/3fydBRm3eCJX7biz/vVTm/2jMT64AQCCYhVy");

        private final String value;

        private ArcKey(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ArcTarget {
        BASE("http://zeus.dl.playstation.net/cdn/UP9000/PCSA00015_00/NYEoaBGfiWymSEVZKxoyrKyBFsZNoFqxdyAIpZayZYuLLbCAArYrYXjPNhKCfXcONmhIZzZEeArycSrjiJOuNMWuWsDONUxMIQtMk.pkg"),
        FIRST("http://gs.ww.np.dl.playstation.net/ppkg/np/PCSA00015/PCSA00015_T5/a4b7d9e35ed56e86/UP9000-PCSA00015_00-WIPEOUT2048BASE0-A0104-V0100-059564fcab8ce66d19b5a563e92677e581313205-PE.pkg"),
        LATEST("http://gs.ww.np.dl.playstation.net/ppkg/np/PCSA00015/PCSA00015_T5/a4b7d9e35ed56e86/UP9000-PCSA00015_00-WIPEOUT2048BASE0-A0104-V0100-059564fcab8ce66d19b5a563e92677e581313205-PE.pkg"),
        ADDON_HD("http://zeus.dl.playstation.net/cdn/UP9000/PCSA00015_00/JYMqGNXUKqHEyNLjbOgrWcJdnQJUMzgadRFWekbWFBXAwMeGikOyiHkXKogKIfqGhtNwKgmNWwwcrJORmRUTDzylBPwjGVnVjyDfh.pkg"),
        ADDON_HD_FURY("http://zeus.dl.playstation.net/cdn/UP9000/PCSA00015_00/IAoJQaDpySenBmQCKiqecEPMzSdPfPcdXupxZXLTYYTuRgtsdTaHxbeejwGKRQpjJOKBdMMFzSoeEhsHYxNUasQrEzkZPeBxUEqnp.pkg");

        private final String value;

        private ArcTarget(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

