/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.StyleContext;
import net.lingala.zip4j.ZipFile;
import org.json.JSONException;
import org.json.JSONObject;

public class MissPiggy
implements ActionListener {
    JFrame frame;
    JPanel frameContainer;
    JPanel actionsContainer;
    JPanel descriptionContainer;
    public JMenuBar menuBar;
    public JMenu fileMenu;
    public JMenu toolsMenu;
    public JMenu helpMenu;
    JScrollPane modListScrollContainer;
    public JList<String> modList;
    private JButton toggleButton;
    private JButton moveUpButton;
    private JButton deleteButton1;
    private JButton moveDownButton;
    private JButton optionsButton;
    private JButton importButton;
    private JButton deployButton;
    private JTextPane descriptionField;
    private JScrollPane descriptionScroller;
    public String priorityList;
    public String blackList;
    public boolean listenersAlreadySet;

    public MissPiggy() {
        this.$$$setupUI$$$();
        this.frame = new JFrame();
        this.listenersAlreadySet = false;
    }

    public void Action() {
        this.Action(false);
    }

    public void Action(boolean forceNag) {
        System.out.println("Main window created");
        System.out.println("Loading program configuration");
        Main.loadConf(this);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.toolsMenu = new JMenu("Tools");
        this.helpMenu = new JMenu("Help");
        this.fileMenu.add(new JMenuItem("Deploy Mods"));
        this.fileMenu.add(new JMenuItem("Import Mod from File"));
        this.fileMenu.add(new JMenuItem("Delete All"));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem("Options"));
        this.fileMenu.add(new JMenuItem("Quit"));
        this.toolsMenu.add(new JMenuItem("Edit Metadata"));
        this.toolsMenu.add(new JMenuItem("Generate New Mod from Folder..."));
        this.toolsMenu.add(new JMenuItem("Create Soundtrack Mod..."));
        this.helpMenu.add(new JMenuItem("Manual"));
        this.helpMenu.add(new JSeparator());
        this.helpMenu.add(new JMenuItem("Source Code"));
        this.helpMenu.add(new JMenuItem("License"));
        this.helpMenu.add(new JSeparator());
        this.helpMenu.add(new JMenuItem("Check for Updates"));
        this.helpMenu.add(new JMenuItem("About Firestar"));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.helpMenu);
        this.menuBar.setVisible(true);
        this.frame.setJMenuBar(this.menuBar);
        this.frame.add(this.frameContainer);
        this.InitializeModListStructure();
        this.InitializeModListInGUI();
        this.fileMenu.getItem(0).addActionListener(this);
        this.fileMenu.getItem(1).addActionListener(this);
        this.fileMenu.getItem(2).addActionListener(this);
        this.fileMenu.getItem(4).addActionListener(this);
        this.fileMenu.getItem(5).addActionListener(this);
        this.toolsMenu.getItem(0).addActionListener(this);
        this.toolsMenu.getItem(1).addActionListener(this);
        this.toolsMenu.getItem(2).addActionListener(this);
        this.helpMenu.getItem(0).addActionListener(this);
        this.helpMenu.getItem(2).addActionListener(this);
        this.helpMenu.getItem(3).addActionListener(this);
        this.helpMenu.getItem(5).addActionListener(this);
        this.helpMenu.getItem(6).addActionListener(this);
        this.deployButton.addActionListener(this);
        this.importButton.addActionListener(this);
        this.deleteButton1.addActionListener(this);
        this.optionsButton.addActionListener(this);
        this.moveUpButton.addActionListener(this);
        this.moveDownButton.addActionListener(this);
        this.toggleButton.addActionListener(this);
        this.descriptionField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        this.frame.setIconImage(Main.windowIcon);
        this.menuBar.setBackground(new Color(25, 41, 93));
        this.fileMenu.setForeground(new Color(255, 255, 255));
        this.fileMenu.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.toolsMenu.setForeground(new Color(255, 255, 255));
        this.toolsMenu.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.helpMenu.setForeground(new Color(255, 255, 255));
        this.helpMenu.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.toggleButton.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.deleteButton1.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.moveDownButton.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.moveUpButton.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.optionsButton.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.importButton.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.deployButton.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        ((DefaultCaret)this.descriptionField.getCaret()).setUpdatePolicy(1);
        this.frame.setSize(800, 600);
        this.frame.setMinimumSize(new Dimension(640, 480));
        this.frame.setTitle("Firestar Mod Manager");
        this.frame.setResizable(true);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new GridLayout());
        this.frame.setLocationRelativeTo(null);
        if (Main.checkUpdates) {
            this.StartErnie(false);
        }
        this.frame.setVisible(true);
    }

    public void InitializeModListStructure() {
        Main.Mods.clear();
        try {
            this.priorityList = new String(Files.readAllBytes(Paths.get(System.getProperty("user.home") + "/.firestar/mods/index", new String[0])));
        }
        catch (IOException e) {
            String[] priorityListFileHandle = new File(System.getProperty("user.home") + "/.firestar/mods/index");
            new File(System.getProperty("user.home") + "/.firestar/mods/").mkdirs();
            if (!priorityListFileHandle.isFile()) {
                try {
                    priorityListFileHandle.createNewFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.priorityList = "";
        }
        String[] pListArray = this.priorityList.split("\n");
        Arrays.sort(pListArray, new NaturalOrderComparator(false));
        System.out.println("Initializing modList from file with length of " + pListArray.length + " units");
        for (String s : pListArray) {
            File mod = new File(System.getProperty("user.home") + "/.firestar/mods/" + s.substring(s.indexOf("=") + 1).trim());
            if (s.split("=")[0].matches("[0-9]+=*") && mod.exists()) {
                Main.Mod m = new Main().new Main.Mod();
                m.path = s.substring(s.indexOf("=") + 1).trim();
                System.out.println("found file " + m.path);
                try {
                    JSONObject metadata = new JSONObject(new ZipFile(System.getProperty("user.home") + "/.firestar/mods/" + m.path).getComment());
                    m.friendlyName = metadata.has("friendlyName") ? metadata.get("friendlyName").toString() : m.path;
                    if (metadata.has("description")) {
                        m.description = metadata.get("description").toString();
                    }
                    if (metadata.has("version")) {
                        m.version = Integer.parseInt(metadata.get("version").toString());
                    }
                    if (metadata.has("author")) {
                        m.author = metadata.get("author").toString();
                    }
                    if (metadata.has("loaderversion")) {
                        m.loaderversion = Integer.parseInt(metadata.get("loaderversion").toString());
                    }
                    if (metadata.has("game")) {
                        m.game = metadata.get("game").toString();
                    }
                    if (m.loaderversion >= 1) {
                        if (metadata.has("requires")) {
                            for (Object i : (ArrayList)metadata.toMap().get("requires")) {
                                m.requires.add(i.toString());
                            }
                        }
                        if (metadata.has("extracts")) {
                            for (Object i : (ArrayList)metadata.toMap().get("extracts")) {
                                m.extracts.add(i.toString());
                            }
                        }
                    }
                    Main.Mods.add(m);
                }
                catch (Exception e) {
                    System.out.println("WARNING: mod entry for " + s + " was found but does not contain valid JSON metadata. skipping");
                    System.out.println(e.getMessage());
                }
                continue;
            }
            if (s.isEmpty()) continue;
            System.out.println("WARNING: mod entry for " + s + " doesn't actually exist. skipping");
        }
        try {
            this.blackList = new String(Files.readAllBytes(Paths.get(System.getProperty("user.home") + "/.firestar/mods/blacklist", new String[0])));
        }
        catch (IOException e) {
            File blackListFileHandle = new File(System.getProperty("user.home") + "/.firestar/mods/blacklist");
            new File(System.getProperty("user.home") + "/.firestar/mods/").mkdirs();
            if (!blackListFileHandle.isFile()) {
                try {
                    blackListFileHandle.createNewFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.blackList = "";
        }
        String[] bListArray = this.blackList.split("\n");
        System.out.println("Initializing blacklist from file with length of " + bListArray.length + " units");
        for (String s : bListArray) {
            for (Main.Mod m : Main.Mods) {
                if (!s.trim().equals(m.path)) continue;
                m.enabled = false;
            }
        }
    }

    public void InitializeModListInGUI() {
        if (this.listenersAlreadySet) {
            this.modList.removeListSelectionListener(this.modList.getListSelectionListeners()[0]);
        }
        this.descriptionField.setText("Select a mod from the list on the right to view more details, or to make changes to your installation.");
        this.modList.clearSelection();
        this.modList.removeAll();
        this.modList.setVisibleRowCount(Main.Mods.size());
        this.modList.setSelectionMode(0);
        String[] contents = new String[Main.Mods.size()];
        System.out.println("Initializing modList to GUI with length of " + Main.Mods.size() + " units");
        for (int i = 0; i < Main.Mods.size(); ++i) {
            if (Main.Mods.get((int)i).friendlyName == null || Main.Mods.get((int)i).friendlyName.isEmpty()) {
                Main.Mods.get((int)i).friendlyName = Main.Mods.get((int)i).path;
            }
            contents[i] = Main.Mods.get((int)i).enabled ? Main.Mods.get((int)i).friendlyName : Main.Mods.get((int)i).friendlyName + " (Disabled)";
            Object authorDisplay = Main.Mods.get((int)i).author == null || Main.Mods.get((int)i).author.isEmpty() ? "Anonymous" : "\"" + Main.Mods.get((int)i).author + "\"";
            System.out.println("Added " + Main.Mods.get((int)i).friendlyName + " by " + (String)authorDisplay);
        }
        this.modList.setListData((String[])contents);
        this.createSelectionEventListener();
    }

    private void StartErnie(final boolean isManual) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                new Ernie(MissPiggy.this.frame, isManual);
            }
        }).start();
    }

    private ListSelectionListener whenItemSelected() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileMenu.getItem(5)) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.fileMenu.getItem(0)) {
            this.deployModGUI();
        } else if (actionEvent.getSource() == this.deployButton) {
            this.deployModGUI();
        } else if (actionEvent.getSource() == this.importButton) {
            this.importModGUI();
        } else if (actionEvent.getSource() == this.fileMenu.getItem(1)) {
            this.importModGUI();
        } else if (actionEvent.getSource() == this.fileMenu.getItem(2)) {
            this.removeAllGUI();
        } else if (actionEvent.getSource() == this.optionsButton) {
            this.optionsGUI();
        } else if (actionEvent.getSource() == this.fileMenu.getItem(4)) {
            this.optionsGUI();
        } else if (actionEvent.getSource() == this.moveUpButton) {
            this.moveUp(this.modList.getSelectedIndex());
        } else if (actionEvent.getSource() == this.moveDownButton) {
            this.moveDown(this.modList.getSelectedIndex());
        } else if (actionEvent.getSource() == this.toggleButton) {
            this.toggleSelected(this.modList.getSelectedIndex());
        } else if (actionEvent.getSource() == this.deleteButton1) {
            this.deleteSelected();
        } else if (actionEvent.getSource() == this.toolsMenu.getItem(0)) {
            this.metaEditorGUI(this.modList.getSelectedIndex());
        } else if (actionEvent.getSource() == this.toolsMenu.getItem(1)) {
            this.generatorGUI();
        } else if (actionEvent.getSource() == this.toolsMenu.getItem(2)) {
            if (!new File(Main.inpath + "at9tool.exe").exists() || !new File(Main.inpath + "ffmpeg.exe").exists()) {
                JOptionPane.showMessageDialog(this.frame, "Your AT9 encoders are missing.\nPlease select \"Get Dependencies\" in the Options menu.", "Error", 0);
            } else {
                new Suggs(this.frame);
            }
        } else if (actionEvent.getSource() == this.helpMenu.getItem(0)) {
            try {
                Desktop.getDesktop().browse(new URI("https://git.worlio.com/bonkmaykr/firestar/wiki/"));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
            }
        } else if (actionEvent.getSource() == this.helpMenu.getItem(2)) {
            try {
                Desktop.getDesktop().browse(new URI("https://git.worlio.com/bonkmaykr/firestar"));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
            }
        } else if (actionEvent.getSource() == this.helpMenu.getItem(3)) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.gnu.org/licenses/gpl-3.0.en.html"));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
            }
        } else if (actionEvent.getSource() == this.helpMenu.getItem(5)) {
            this.StartErnie(true);
        } else if (actionEvent.getSource() == this.helpMenu.getItem(6)) {
            new Rowlf(this.frame);
        }
    }

    public void deployModGUI() {
        int i = 0;
        for (Main.Mod m : Main.Mods) {
            if (!m.enabled) continue;
            ++i;
        }
        if (i > 0) {
            int result = JOptionPane.showConfirmDialog(this.frame, "A new PSARC will be generated. This can take several minutes.\nDuring this time, your computer may be very busy or slow.\n\nIt will be placed in: " + Main.outpath + "\n\nAre you sure you want to continue?", "Deploy Mods", 0, 3);
            if (result == 0) {
                this.frame.setDefaultCloseOperation(0);
                this.frame.setEnabled(false);
                if (!new File(Main.inpath + "psp2psarc.exe").exists()) {
                    JOptionPane.showMessageDialog(this.frame, "psp2psarc is missing.\nPlease select \"Get Dependencies\" in the Options menu.", "Error", 0);
                    this.wrapUpDeployment();
                    return;
                }
                if (!(new File(Main.inpath + "data.psarc").exists() || new File(Main.inpath + "data1.psarc").exists() || new File(Main.inpath + "data2.psarc").exists() || new File(Main.inpath + "dlc1.psarc").exists() || new File(Main.inpath + "dlc2.psarc").exists())) {
                    JOptionPane.showMessageDialog(this.frame, "You have no PSARCs.\nPlease dump your copy of WipEout 2048 or download a PSARC from the Options menu.", "Error", 0);
                    this.wrapUpDeployment();
                    return;
                }
                new Gonzo().DeployMods(this);
            }
        } else {
            JOptionPane.showMessageDialog(this.frame, "Please add at least one mod file to continue.", "Error", 0);
        }
    }

    public void wrapUpDeployment() {
        this.frame.setDefaultCloseOperation(3);
        this.frame.setEnabled(true);
    }

    public void importModGUI() {
        block7: {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("ZIP Archive", "zip"));
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Firestar Mod Package", "fstar"));
            int result = fileChooser.showOpenDialog(this.frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                System.out.println("Importing selected mod file \"" + selectedFile.getName() + "\"");
                ZipFile zipImporterHandler = new ZipFile(selectedFile.getAbsolutePath());
                if (zipImporterHandler.isValidZipFile()) {
                    try {
                        JSONObject json = new JSONObject(new ZipFile(selectedFile.getAbsolutePath()).getComment());
                        if ((Integer)json.get("loaderversion") <= 1) {
                            int min = 0;
                            int max = 9;
                            int rand_int = (int)(Math.random() * (double)(max - min + 1)) + min;
                            int rand_int2 = (int)(Math.random() * (double)(max - min + 1)) + min;
                            int rand_int3 = (int)(Math.random() * (double)(max - min + 1)) + min;
                            Path importDestination = Paths.get(System.getProperty("user.home") + "/.firestar/mods/" + selectedFile.getName() + "_" + rand_int + rand_int2 + rand_int3 + System.currentTimeMillis() + ".zip", new String[0]);
                            Files.copy(Paths.get(selectedFile.getPath(), new String[0]), importDestination, StandardCopyOption.REPLACE_EXISTING);
                            String importDestinationName = importDestination.toFile().getName();
                            BufferedWriter bw = new BufferedWriter(new FileWriter(System.getProperty("user.home") + "/.firestar/mods/index", true));
                            bw.write(Main.Mods.size() + "=" + importDestinationName);
                            bw.newLine();
                            bw.close();
                            this.InitializeModListStructure();
                            this.InitializeModListInGUI();
                            break block7;
                        }
                        System.out.println("ERROR: This mod requires feature level " + json.get("loaderversion").toString() + ", but you have level 1.");
                        JOptionPane.showMessageDialog(this.frame, "This mod requires feature level " + json.get("loaderversion").toString() + ", but you have level 1.\nPlease update Firestar to the latest version.", "Error", 0);
                    }
                    catch (JSONException e) {
                        System.out.println("ERROR: File is not a valid ZIP archive with mod data. Aborting.");
                        JOptionPane.showMessageDialog(this.frame, "Whoops, that's not a valid mod file.", "Error", 0);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        JOptionPane.showMessageDialog(this.frame, "An error has occured.\n" + e.getMessage(), "Error", 0);
                    }
                } else {
                    System.out.println("ERROR: File is not a valid ZIP archive with mod data. Aborting.");
                    JOptionPane.showMessageDialog(this.frame, "Whoops, that's not a valid mod file.", "Error", 0);
                }
            }
        }
    }

    public void removeAllGUI() {
        int result = JOptionPane.showConfirmDialog(this.frame, "Do you really want to delete all mods?", "Remove All", 0, 2);
        if (result == 0) {
            Main.deleteDir(new File(System.getProperty("user.home") + "/.firestar/mods/"));
            Main.Mods.clear();
            this.InitializeModListStructure();
            this.InitializeModListInGUI();
        }
    }

    public void optionsGUI() {
        new Waldorf().Action(this);
        this.frame.setEnabled(false);
    }

    public void deleteSelected() {
        if (this.modList.getSelectedIndex() >= 0) {
            File file = new File(System.getProperty("user.home") + "/.firestar/mods/" + Main.Mods.get((int)this.modList.getSelectedIndex()).path);
            file.delete();
            System.out.println("Deleted " + Main.Mods.get((int)this.modList.getSelectedIndex()).friendlyName);
            Main.Mods.remove(this.modList.getSelectedIndex());
            this.regenerateModBlacklist(false);
            this.regenerateModIndex(true);
        } else {
            JOptionPane.showMessageDialog(this.frame, "Please select a mod to delete first.", "Error", 0);
        }
    }

    public void generatorGUI() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(this.frame);
        if (result == 0) {
            if (fileChooser.getSelectedFile().isDirectory() && new File(fileChooser.getSelectedFile().getAbsolutePath() + "/data").isDirectory()) {
                File file = fileChooser.getSelectedFile();
                new Clifford().Action(this, file);
                this.frame.setEnabled(false);
            } else {
                JOptionPane.showMessageDialog(this.frame, "You must select a folder containing a \"data\" directory with game assets.", "Error", 0);
            }
        }
    }

    public void metaEditorGUI(int index) {
        if (index >= 0) {
            new Clifford().Action(this, index);
            this.frame.setEnabled(false);
        } else {
            JOptionPane.showMessageDialog(this.frame, "Please select a mod to edit first.", "Error", 0);
        }
    }

    private void moveUp(int index) {
        if (index > 0) {
            Collections.swap(Main.Mods, index, index - 1);
            System.out.println("Items moved, redeploying list");
            this.regenerateModIndex(true);
            this.modList.setSelectedIndex(index - 1);
        }
    }

    private void moveDown(int index) {
        if (index < Main.Mods.size() - 1) {
            Collections.swap(Main.Mods, index, index + 1);
            System.out.println("Items moved, redeploying list");
            this.regenerateModIndex(true);
            this.modList.setSelectedIndex(index + 1);
        }
    }

    private void toggleSelected(int index) {
        if (index >= 0) {
            Main.Mods.get((int)index).enabled = !Main.Mods.get((int)index).enabled;
            this.regenerateModBlacklist(true);
            this.modList.setSelectedIndex(index);
        } else {
            JOptionPane.showMessageDialog(this.frame, "Please select a mod to toggle first.", "Error", 0);
        }
    }

    public void throwUnimplemented() {
        JOptionPane.showMessageDialog(this.frame, "This feature is unimplemented and will be coming soon.\nSee README at https://git.worlio.com/bonkmaykr/firestar", "Unimplemented", 1);
    }

    public void createSelectionEventListener() {
        this.listenersAlreadySet = true;
        this.modList.addListSelectionListener(e -> {
            block6: {
                if (this.modList.getSelectedIndex() >= 0 && this.modList.getModel().getSize() >= 1) {
                    try {
                        File pathReference = new File(System.getProperty("user.home") + "/.firestar/mods/" + Main.Mods.get((int)this.modList.getSelectedIndex()).path);
                        DecimalFormat df = new DecimalFormat("##.##");
                        df.setRoundingMode(RoundingMode.UP);
                        float modFileSize = pathReference.length();
                        String modFileSizeStr = String.valueOf(modFileSize);
                        String modFileSizeUnits = "bytes";
                        if (pathReference.length() >= 1024L) {
                            modFileSizeStr = String.valueOf(df.format(modFileSize / 1024.0f));
                            modFileSizeUnits = "Kilobytes";
                        }
                        if (pathReference.length() >= 0x100000L) {
                            modFileSizeStr = String.valueOf(df.format(modFileSize / 1048576.0f));
                            modFileSizeUnits = "Megabytes";
                        }
                        if (pathReference.length() >= 0x40000000L) {
                            modFileSizeStr = String.valueOf(df.format(modFileSize / 1.0737418E9f));
                            modFileSizeUnits = "Gigabytes";
                        }
                        String authorDisplay = Main.Mods.get((int)this.modList.getSelectedIndex()).author == null || Main.Mods.get((int)this.modList.getSelectedIndex()).author.isEmpty() ? "an Unknown Author" : Main.Mods.get((int)this.modList.getSelectedIndex()).author;
                        this.descriptionField.setText("\"" + Main.Mods.get((int)this.modList.getSelectedIndex()).friendlyName + "\"\nby " + authorDisplay + "\n\nVersion " + Main.Mods.get((int)this.modList.getSelectedIndex()).version + "\n" + modFileSizeStr + " " + modFileSizeUnits + " in size\n\n" + Main.Mods.get((int)this.modList.getSelectedIndex()).description);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        System.out.println(ex.getMessage());
                        System.out.println("mods " + Main.Mods.size());
                        System.out.println("mod display " + this.modList.getModel().getSize());
                        System.out.println("selection index " + this.modList.getSelectedIndex());
                        int result = JOptionPane.showConfirmDialog(this.frame, "Firestar encountered an internal error.\n" + ex.getMessage(), "Fatal Error", -1, 0);
                        if (result != 0) break block6;
                        System.exit(1);
                    }
                }
            }
        });
    }

    public void regenerateModIndex(boolean reload) {
        try {
            System.out.println("Regenerating index...");
            new File(System.getProperty("user.home") + "/.firestar/mods/index").delete();
            File priorityListFileHandle = new File(System.getProperty("user.home") + "/.firestar/mods/index");
            priorityListFileHandle.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(System.getProperty("user.home") + "/.firestar/mods/index", true));
            int i = 0;
            for (Main.Mod m : Main.Mods) {
                bw.write(i + "=" + m.path);
                bw.newLine();
                ++i;
            }
            bw.close();
            System.out.println("Mod index file regenerated.");
            if (reload) {
                Main.Mods.clear();
                this.priorityList = "";
                this.InitializeModListStructure();
                this.InitializeModListInGUI();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            JOptionPane.showMessageDialog(this.frame, "An error has occured.\n" + e.getMessage(), "Error", 0);
        }
    }

    public void regenerateModBlacklist(boolean reload) {
        try {
            System.out.println("Regenerating blacklist...");
            new File(System.getProperty("user.home") + "/.firestar/mods/blacklist").delete();
            File blackListFileHandle = new File(System.getProperty("user.home") + "/.firestar/mods/blacklist");
            blackListFileHandle.createNewFile();
            BufferedWriter bw2 = new BufferedWriter(new FileWriter(System.getProperty("user.home") + "/.firestar/mods/blacklist", true));
            int i2 = 0;
            for (Main.Mod m : Main.Mods) {
                if (m.enabled) continue;
                bw2.write(m.path);
                bw2.newLine();
                ++i2;
            }
            bw2.close();
            System.out.println("Mod blacklist file regenerated.");
            if (reload) {
                Main.Mods.clear();
                this.blackList = "";
                this.InitializeModListStructure();
                this.InitializeModListInGUI();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            JOptionPane.showMessageDialog(this.frame, "An error has occured.\n" + e.getMessage(), "Error", 0);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JPanel jPanel;
        JScrollPane jScrollPane;
        JTextPane jTextPane;
        JScrollPane jScrollPane2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.frameContainer = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-15128227));
        ((Component)jPanel3).setForeground(new Color(-15128227));
        this.descriptionContainer = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-15128227));
        ((Component)jPanel2).setForeground(new Color(-1));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 7, new Dimension(300, -1), new Dimension(300, 262), new Dimension(300, -1)));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), "Description", 0, 0, this.$$$getFont$$$("Exo 2", -1, -1, jPanel2.getFont()), new Color(-1)));
        this.descriptionScroller = jScrollPane2 = new JScrollPane();
        jScrollPane2.setAutoscrolls(false);
        ((Component)jScrollPane2).setForeground(new Color(-1));
        jScrollPane2.setOpaque(false);
        jPanel2.add((Component)jScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.descriptionField = jTextPane = new JTextPane();
        ((Component)jTextPane).setBackground(new Color(-15128227));
        jTextPane.setEditable(false);
        jTextPane.setFocusable(false);
        Font font = this.$$$getFont$$$("Exo 2", -1, -1, jTextPane.getFont());
        if (font != null) {
            jTextPane.setFont(font);
        }
        ((Component)jTextPane).setForeground(new Color(-1));
        jTextPane.setText("Select a mod from the list on the right to view more details, or to make changes to your installation.");
        jScrollPane2.setViewportView(jTextPane);
        this.modListScrollContainer = jScrollPane = new JScrollPane();
        ((Component)jScrollPane).setBackground(new Color(-15128227));
        ((Component)jScrollPane).setForeground(new Color(-1));
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 1, 2, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), "Mods List", 1, 2, this.$$$getFont$$$("Exo 2", -1, -1, jScrollPane.getFont()), new Color(-1)));
        JList jList = new JList();
        this.modList = jList;
        ((Component)jList).setBackground(new Color(-15128227));
        ((Component)jList).setForeground(new Color(-1));
        jList.setOpaque(true);
        jList.setSelectionBackground(new Color(-2271221));
        jList.setSelectionForeground(new Color(-1));
        jList.setValueIsAdjusting(false);
        jList.putClientProperty("html.disable", Boolean.TRUE);
        jScrollPane.setViewportView(jList);
        this.actionsContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        ((Component)jPanel).setBackground(new Color(-15128227));
        ((Component)jPanel).setForeground(new Color(-1));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 3, new Dimension(300, 200), new Dimension(300, 200), new Dimension(300, 200)));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), "Actions", 0, 0, this.$$$getFont$$$("Exo 2", -1, -1, jPanel.getFont()), new Color(-1)));
        this.toggleButton = jButton7 = new JButton();
        ((Component)jButton7).setBackground(new Color(-2271221));
        jButton7.setBorderPainted(false);
        jButton7.setFocusPainted(false);
        Font font2 = this.$$$getFont$$$("Exo 2", 1, -1, jButton7.getFont());
        if (font2 != null) {
            jButton7.setFont(font2);
        }
        ((Component)jButton7).setForeground(new Color(-1));
        jButton7.setText("Toggle");
        jPanel.add((Component)jButton7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, new Dimension(-1, 30), null, new Dimension(-1, 30)));
        this.moveUpButton = jButton6 = new JButton();
        ((Component)jButton6).setBackground(new Color(-2271221));
        jButton6.setBorderPainted(false);
        jButton6.setFocusPainted(false);
        Font font3 = this.$$$getFont$$$("Exo 2", 1, -1, jButton6.getFont());
        if (font3 != null) {
            jButton6.setFont(font3);
        }
        ((Component)jButton6).setForeground(new Color(-1));
        jButton6.setText("Move Up");
        jPanel.add((Component)jButton6, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 0, new Dimension(-1, 30), null, new Dimension(-1, 30)));
        this.deleteButton1 = jButton5 = new JButton();
        jButton5.setAlignmentX(0.0f);
        ((Component)jButton5).setBackground(new Color(-2271221));
        jButton5.setBorderPainted(false);
        jButton5.setFocusPainted(false);
        Font font4 = this.$$$getFont$$$("Exo 2", 1, -1, jButton5.getFont());
        if (font4 != null) {
            jButton5.setFont(font4);
        }
        ((Component)jButton5).setForeground(new Color(-1));
        jButton5.setText("Delete");
        jPanel.add((Component)jButton5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, new Dimension(-1, 30), new Dimension(98, 56), new Dimension(-1, 30)));
        this.moveDownButton = jButton4 = new JButton();
        ((Component)jButton4).setBackground(new Color(-2271221));
        jButton4.setBorderPainted(false);
        jButton4.setFocusPainted(false);
        Font font5 = this.$$$getFont$$$("Exo 2", 1, -1, jButton4.getFont());
        if (font5 != null) {
            jButton4.setFont(font5);
        }
        ((Component)jButton4).setForeground(new Color(-1));
        jButton4.setText("Move Down");
        jPanel.add((Component)jButton4, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 0, new Dimension(-1, 30), new Dimension(115, 56), new Dimension(-1, 30)));
        this.optionsButton = jButton3 = new JButton();
        ((Component)jButton3).setBackground(new Color(-2271221));
        jButton3.setBorderPainted(false);
        jButton3.setFocusPainted(false);
        Font font6 = this.$$$getFont$$$("Exo 2", 1, -1, jButton3.getFont());
        if (font6 != null) {
            jButton3.setFont(font6);
        }
        ((Component)jButton3).setForeground(new Color(-1));
        jButton3.setText("Options");
        jPanel.add((Component)jButton3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 4, null, null, new Dimension(-1, 75)));
        this.importButton = jButton2 = new JButton();
        ((Component)jButton2).setBackground(new Color(-2271221));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        Font font7 = this.$$$getFont$$$("Exo 2", 1, -1, jButton2.getFont());
        if (font7 != null) {
            jButton2.setFont(font7);
        }
        ((Component)jButton2).setForeground(new Color(-1));
        jButton2.setText("Import");
        jPanel.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 4, null, null, new Dimension(-1, 75)));
        this.deployButton = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-2271221));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        Font font8 = this.$$$getFont$$$("Exo 2", 1, -1, jButton.getFont());
        if (font8 != null) {
            jButton.setFont(font8);
        }
        ((Component)jButton).setForeground(new Color(-1));
        jButton.setText("Deploy");
        jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 4, null, new Dimension(79, 28), new Dimension(-1, 75)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.frameContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

