/*
 * Decompiled with CFR 0.152.
 */
import java.util.Comparator;

public final class NaturalOrderComparator<T>
implements Comparator<T> {
    public static final Comparator<String> NUMERICAL_ORDER = new NaturalOrderComparator<String>(false);
    public static final Comparator<String> CASEINSENSITIVE_NUMERICAL_ORDER = new NaturalOrderComparator<String>(true);
    private final boolean caseInsensitive;

    public NaturalOrderComparator(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                return bias;
            }
            if (!Character.isDigit(ca)) {
                return -1;
            }
            if (!Character.isDigit(cb)) {
                return 1;
            }
            if (ca < cb) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (ca > cb) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            ++ia;
            ++ib;
        }
    }

    @Override
    public int compare(T o1, T o2) {
        String a = o1.toString();
        String b = o2.toString();
        int ia = 0;
        int ib = 0;
        int nza = 0;
        int nzb = 0;
        while (true) {
            int result;
            nzb = 0;
            nza = 0;
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            while (ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                if (!Character.isDigit(this.charAt(a, ia + 1))) break;
                ca = this.charAt(a, ++ia);
            }
            while (cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                if (!Character.isDigit(this.charAt(b, ib + 1))) break;
                cb = this.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (result = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return result;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return nza - nzb;
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    private char charAt(String s, int i) {
        if (i >= s.length()) {
            return '\u0000';
        }
        return this.caseInsensitive ? Character.toUpperCase(s.charAt(i)) : s.charAt(i);
    }
}

