/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Suggs
implements ActionListener,
ListSelectionListener {
    public JFrame frame;
    private JPanel frameContainer;
    private JList dSongList;
    private JButton moveDownBtn;
    private JButton saveBtn;
    private JButton cancelBtn;
    private JTextField fTitle;
    private JTextField fArtist;
    private JLabel dTrackNo;
    private JLabel dFileSize;
    private JButton frontendDemoChooseBtn;
    private JButton frontendMainChooseBtn;
    private JButton deleteSongBtn;
    private JButton addSongBtn;
    private JButton moveUpBtn;
    private JLabel dSTitle;
    private JLabel dMTitle;
    private JLabel dSSize;
    private JLabel dMSize;
    private JCheckBox checkAdditive;
    private JButton spDeleteBtn;
    private JButton mpDeleteBtn;
    private JCheckBox checkNormalize;
    private Scooter progressDialog;
    JFrame parent;
    int curIndex;
    boolean normalizeVolumes;
    private List<AudioTrack> tracklist;
    private File sptrack;
    private File mptrack;
    DocumentListener id3TagEditorHandler;

    public Suggs(final JFrame parent) {
        this.$$$setupUI$$$();
        this.frame = new JFrame();
        this.curIndex = -1;
        this.normalizeVolumes = false;
        this.tracklist = new ArrayList<AudioTrack>();
        this.id3TagEditorHandler = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                Suggs.this.updateSelectionToMatchTextFields();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                Suggs.this.updateSelectionToMatchTextFields();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                Suggs.this.updateSelectionToMatchTextFields();
            }
        };
        this.parent = parent;
        parent.setEnabled(false);
        this.frame.setIconImage(Main.windowIcon);
        this.frame.add(this.frameContainer);
        this.frame.setSize(700, 400);
        this.frame.setMinimumSize(new Dimension(700, 400));
        this.frame.setTitle("Soundtrack Mod Generator");
        this.frame.setResizable(true);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setLayout(new GridLayout());
        this.frame.setLocationRelativeTo(parent);
        this.frame.setAlwaysOnTop(true);
        this.cancelBtn.addActionListener(this);
        this.saveBtn.addActionListener(this);
        this.addSongBtn.addActionListener(this);
        this.deleteSongBtn.addActionListener(this);
        this.moveUpBtn.addActionListener(this);
        this.moveDownBtn.addActionListener(this);
        this.fTitle.addActionListener(this);
        this.fArtist.addActionListener(this);
        this.frontendMainChooseBtn.addActionListener(this);
        this.frontendDemoChooseBtn.addActionListener(this);
        this.spDeleteBtn.addActionListener(this);
        this.mpDeleteBtn.addActionListener(this);
        this.dSongList.addListSelectionListener(this);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int result;
                if (!(Suggs.this.tracklist.isEmpty() && Suggs.this.sptrack == null && Suggs.this.mptrack == null || (result = JOptionPane.showConfirmDialog(Suggs.this.frame, "Are you sure?\nAll unsaved changes will be lost.", "Soundtrack Mod Generator", 0, 2)) != 1)) {
                    return;
                }
                parent.setEnabled(true);
                e.getWindow().dispose();
            }
        });
        this.fTitle.setText("");
        this.fArtist.setText("");
        this.dTrackNo.setText("\u200e");
        this.dFileSize.setText("\u200e");
        this.fTitle.setEnabled(false);
        this.fArtist.setEnabled(false);
        this.fTitle.getDocument().addDocumentListener(this.id3TagEditorHandler);
        this.fArtist.getDocument().addDocumentListener(this.id3TagEditorHandler);
        this.frame.setVisible(true);
    }

    private void haveSeggs() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelBtn) {
            int result;
            if (!(this.tracklist.isEmpty() && this.sptrack == null && this.mptrack == null || (result = JOptionPane.showConfirmDialog(this.frame, "Are you sure?\nAll unsaved changes will be lost.", "Soundtrack Mod Generator", 0, 2)) != 1)) {
                return;
            }
            this.parent.setEnabled(true);
            this.frame.dispose();
        } else if (actionEvent.getSource() == this.addSongBtn) {
            this.addSong();
        } else if (actionEvent.getSource() == this.deleteSongBtn) {
            this.remove(this.curIndex);
        } else if (actionEvent.getSource() == this.moveUpBtn) {
            this.moveUp(this.curIndex);
        } else if (actionEvent.getSource() == this.moveDownBtn) {
            this.moveDown(this.curIndex);
        } else if (actionEvent.getSource() == this.frontendMainChooseBtn) {
            this.setSPMusic();
        } else if (actionEvent.getSource() == this.frontendDemoChooseBtn) {
            this.setMPMusic();
        } else if (actionEvent.getSource() == this.saveBtn) {
            if (this.tracklist.isEmpty() && this.sptrack == null && this.mptrack == null) {
                JOptionPane.showMessageDialog(this.frame, "Please add at least one song to the playlist.", "Error", 0);
                return;
            }
            Object deets = this.tracklist.isEmpty() ? "no songs" : this.tracklist.size() + " songs";
            if (this.sptrack != null && this.mptrack == null) {
                deets = (String)deets + " and a custom campaign menu track";
            } else if (this.mptrack != null && this.sptrack == null) {
                deets = (String)deets + " and a custom lobby menu track";
            } else if (this.mptrack != null && this.sptrack != null) {
                deets = (String)deets + ", a custom campaign menu track, and a custom lobby menu track";
            }
            int result = JOptionPane.showConfirmDialog(this.frame, "Your custom playlist with " + (String)deets + " will be generated.\nPress YES to continue, or NO to continue editing.", "Soundtrack Mod Generator", 0, 3);
            if (result == 0) {
                this.save();
            }
        } else if (actionEvent.getSource() == this.spDeleteBtn) {
            this.dSTitle.setToolTipText(null);
            this.dSTitle.setText("no track");
            this.dSSize.setText("no size");
            this.sptrack = null;
            this.spDeleteBtn.setVisible(false);
        } else if (actionEvent.getSource() == this.mpDeleteBtn) {
            this.dMTitle.setToolTipText(null);
            this.dMTitle.setText("no track");
            this.dMSize.setText("no size");
            this.mptrack = null;
            this.mpDeleteBtn.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fTitle.getDocument().removeDocumentListener(this.id3TagEditorHandler);
        this.fArtist.getDocument().removeDocumentListener(this.id3TagEditorHandler);
        this.curIndex = this.dSongList.getSelectedIndex();
        if (this.curIndex >= 0) {
            this.fTitle.setEnabled(true);
            this.fArtist.setEnabled(true);
            AudioTrack at = this.tracklist.get(this.curIndex);
            this.fTitle.setText(at.title);
            this.fArtist.setText(at.artist);
            this.dTrackNo.setText(String.format("MT_%02d", this.curIndex + 1));
            this.dFileSize.setText(at.size + " B");
            if (at.size > 1023L) {
                this.dFileSize.setText(at.size / 1024L + " KB");
            }
            if (at.size > 1048575L) {
                this.dFileSize.setText(at.size / 0x100000L + " MB");
            }
            this.fTitle.getDocument().addDocumentListener(this.id3TagEditorHandler);
            this.fArtist.getDocument().addDocumentListener(this.id3TagEditorHandler);
        } else {
            this.fTitle.setEnabled(false);
            this.fArtist.setEnabled(false);
            this.fTitle.setText("");
            this.fArtist.setText("");
            this.dTrackNo.setText("\u200e");
            this.dFileSize.setText("\u200e");
            this.fTitle.getDocument().addDocumentListener(this.id3TagEditorHandler);
            this.fArtist.getDocument().addDocumentListener(this.id3TagEditorHandler);
        }
    }

    private void updateSelectionToMatchTextFields() {
        this.tracklist.get((int)this.curIndex).title = this.fTitle.getText();
        this.tracklist.get((int)this.curIndex).artist = this.fArtist.getText();
        this.InitializeSongListInGUI();
        this.dSongList.setSelectedIndex(this.curIndex);
    }

    private void remove(int index) {
        if (index >= 0) {
            this.tracklist.remove(index);
            this.InitializeSongListInGUI();
        }
    }

    private void moveUp(int index) {
        if (index > 0) {
            Collections.swap(this.tracklist, index, index - 1);
            --this.curIndex;
            this.InitializeSongListInGUI();
        }
    }

    private void moveDown(int index) {
        if (index < this.tracklist.size() - 1) {
            Collections.swap(this.tracklist, index, index + 1);
            ++this.curIndex;
            this.InitializeSongListInGUI();
        }
    }

    private void InitializeSongListInGUI() {
        this.dSongList.removeListSelectionListener(this);
        this.dSongList.clearSelection();
        this.dSongList.removeAll();
        this.dSongList.setVisibleRowCount(this.tracklist.size());
        this.dSongList.setSelectionMode(0);
        String[] contents = new String[this.tracklist.size()];
        for (int i = 0; i < this.tracklist.size(); ++i) {
            String dTitleInList = this.tracklist.get((int)i).title == null || this.tracklist.get((int)i).title.isEmpty() ? this.tracklist.get((int)i).path.getName() : this.tracklist.get((int)i).title;
            String dArtistInList = this.tracklist.get((int)i).artist == null || this.tracklist.get((int)i).artist.isEmpty() ? "Unknown Artist" : this.tracklist.get((int)i).artist;
            contents[i] = dArtistInList + " - " + dTitleInList;
        }
        this.dSongList.setListData(contents);
        this.dSongList.setSelectedIndex(this.curIndex);
        this.dSongList.addListSelectionListener(this);
    }

    private JFileChooser commonSoundFilePicker(boolean multiselect) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(multiselect);
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        fileChooser.setFileFilter(new FileNameExtensionFilter("All Compatible Files", "mp3", "ogg", "oga", "opus", "m4a", "3gp", "wav", "wave", "aif", "aiff", "aifc", "flac", "at3", "at9"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("MPEG Audio Layer 3", "mp3"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Ogg Audio", "ogg", "oga", "opus"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("AAC or MPEG-4 Audio", "m4a", "3gp"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("IBM/Microsoft WAVE", "wav", "wave"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Apple AIFF", "aif", "aiff", "aifc"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Free Lossless Audio Codec", "flac"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Sony ATRAC3", "at3"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Sony ATRAC9", "at9"));
        return fileChooser;
    }

    private void setSPMusic() {
        JFileChooser fileChooser = this.commonSoundFilePicker(false);
        int result = fileChooser.showOpenDialog(this.frame);
        if (result == 0) {
            File selectedFile;
            this.sptrack = selectedFile = fileChooser.getSelectedFile();
            this.dSTitle.setText(selectedFile.getName().substring(0, Math.min(selectedFile.getName().length(), 20)));
            if (selectedFile.getName().length() > 20) {
                this.dSTitle.setToolTipText(selectedFile.getName());
            }
            this.dSSize.setText(selectedFile.length() + " B");
            if (selectedFile.length() > 1023L) {
                this.dSSize.setText(selectedFile.length() / 1024L + " KB");
            }
            if (selectedFile.length() > 1048575L) {
                this.dSSize.setText(selectedFile.length() / 0x100000L + " MB");
            }
            this.spDeleteBtn.setVisible(true);
        }
    }

    private void setMPMusic() {
        JFileChooser fileChooser = this.commonSoundFilePicker(false);
        int result = fileChooser.showOpenDialog(this.frame);
        if (result == 0) {
            File selectedFile;
            this.mptrack = selectedFile = fileChooser.getSelectedFile();
            this.dMTitle.setText(selectedFile.getName().substring(0, Math.min(selectedFile.getName().length(), 20)));
            if (selectedFile.getName().length() > 20) {
                this.dMTitle.setToolTipText(selectedFile.getName());
            }
            this.dMSize.setText(selectedFile.length() + " B");
            if (selectedFile.length() > 1023L) {
                this.dMSize.setText(selectedFile.length() / 1024L + " KB");
            }
            if (selectedFile.length() > 1048575L) {
                this.dMSize.setText(selectedFile.length() / 0x100000L + " MB");
            }
            this.mpDeleteBtn.setVisible(true);
        }
    }

    private void addSong() {
        JFileChooser fileChooser = this.commonSoundFilePicker(true);
        int result = fileChooser.showOpenDialog(this.frame);
        if (result == 0) {
            File[] selectedFiles;
            for (File f : selectedFiles = fileChooser.getSelectedFiles()) {
                if (!f.exists()) continue;
                System.out.println("Importing audio file \"" + f.getName() + "\"");
                AudioTrack track = new AudioTrack();
                track.path = f;
                String fname = f.getName();
                if (fname.contains(" - ")) {
                    track.title = fname.substring(fname.indexOf(" - ") + 3, fname.lastIndexOf("."));
                    track.artist = fname.substring(0, fname.indexOf(" - "));
                } else {
                    track.title = fname;
                }
                track.size = f.length();
                this.tracklist.add(track);
            }
            this.InitializeSongListInGUI();
        }
    }

    private void save() {
        this.frame.setEnabled(false);
        this.frame.setAlwaysOnTop(false);
        this.normalizeVolumes = this.checkNormalize.isSelected();
        Main.deleteDir(new File(System.getProperty("user.home") + "/.firestar/temp/"));
        new Thread(() -> {
            int progressSize = this.tracklist.size() + (this.sptrack != null ? 1 : 0) + (this.mptrack != null ? 1 : 0) + 1;
            this.progressDialog = new Scooter();
            this.progressDialog.showDialog("Soundtrack Mod Generator");
            this.progressDialog.setText("Generating audio files...");
            this.progressDialog.setProgressMax(progressSize);
            this.progressDialog.setProgressValue(0);
            this.progressDialog.progressBar.setStringPainted(false);
            try {
                Thread ioThread;
                new File(Main.inpath + "temp/data/audio/music").mkdirs();
                FileOutputStream fos = new FileOutputStream(new File(Main.inpath + "temp/fscript"));
                PrintStream ps = new PrintStream(fos);
                ps.println("fscript 1");
                ps.println("# AUTOGENERATED BY FIRESTAR");
                for (int i = 0; i < this.tracklist.size(); ++i) {
                    AudioTrack at = this.tracklist.get(i);
                    String trackno = String.format("%02d", i + 1);
                    String oTitle = at.title == null ? "" : at.title;
                    String oArtist = at.artist == null ? "" : at.artist;
                    new File(Main.inpath + "temp/data/audio/music/" + trackno).mkdirs();
                    if (at.path.getName().endsWith(".at9")) {
                        this.progressDialog.setText("Copying track " + (i + 1) + " out of " + this.tracklist.size() + "...");
                        try {
                            System.out.println("Copying track #" + (i + 1) + " \"" + at.artist + " - " + at.title + "\"...");
                            Files.copy(at.path.toPath(), Paths.get(Main.inpath + "temp/data/audio/music/" + trackno + "/music_stereo.at9", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Suggs.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        this.progressDialog.setText("Encoding track " + (i + 1) + " out of " + this.tracklist.size() + "...");
                        try {
                            Thread ioThread2;
                            Process p;
                            System.out.println("Encoding track #" + (i + 1) + " \"" + oArtist + " - " + oTitle + "\"...");
                            if (this.normalizeVolumes) {
                                new File(Main.inpath + "temp/ffmpeg/").mkdirs();
                                p = Main.exec(new String[]{Main.inpath + "ffmpeg.exe", "-y", "-i", at.path.getPath(), "-filter", "loudnorm=linear=true:i=-5.0:lra=7.0:tp=0.0", "-ar", "44100", "ffmpeg/" + at.path.getName() + "_normalized.wav"}, Main.inpath + "temp/");
                                ioThread2 = new Thread(){

                                    @Override
                                    public void run() {
                                        Main.printProcessLogToStdOut(p);
                                    }
                                };
                                ioThread2.start();
                                p.waitFor();
                                at.path = new File(Main.inpath + "temp/ffmpeg/" + at.path.getName() + "_normalized.wav");
                            } else {
                                new File(Main.inpath + "temp/ffmpeg/").mkdirs();
                                p = Main.exec(new String[]{Main.inpath + "ffmpeg.exe", "-y", "-i", at.path.getPath(), "-ar", "44100", "ffmpeg/" + at.path.getName() + ".wav"}, Main.inpath + "temp/");
                                ioThread2 = new Thread(){

                                    @Override
                                    public void run() {
                                        Main.printProcessLogToStdOut(p);
                                    }
                                };
                                ioThread2.start();
                                p.waitFor();
                                at.path = new File(Main.inpath + "temp/ffmpeg/" + at.path.getName() + ".wav");
                            }
                            p = Main.exec(new String[]{Main.inpath + "at9tool.exe", "-e", "-br", "144", at.path.getPath(), "data/audio/music/" + trackno + "/music_stereo.at9"}, Main.inpath + "temp/");
                            ioThread2 = new Thread(){

                                @Override
                                public void run() {
                                    Main.printProcessLogToStdOut(p);
                                }
                            };
                            ioThread2.start();
                            p.waitFor();
                            Main.deleteDir(new File(Main.inpath + "temp/ffmpeg/"));
                        }
                        catch (IOException | InterruptedException ex) {
                            Logger.getLogger(Suggs.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    String ocmd = "modify";
                    if (i >= 12) {
                        ocmd = "create";
                    }
                    Object oArtistLine = !oArtist.isEmpty() ? oArtist.replace("\"", "\\\"") + "\\n" : "";
                    for (int i2 = 0; i2 < 15; ++i2) {
                        String language = "INTERNAL_ERROR";
                        switch (i2) {
                            case 0: {
                                language = "american";
                                break;
                            }
                            case 1: {
                                language = "danish";
                                break;
                            }
                            case 2: {
                                language = "dutch";
                                break;
                            }
                            case 3: {
                                language = "english";
                                break;
                            }
                            case 4: {
                                language = "finnish";
                                break;
                            }
                            case 5: {
                                language = "french";
                                break;
                            }
                            case 6: {
                                language = "german";
                                break;
                            }
                            case 7: {
                                language = "italian";
                                break;
                            }
                            case 8: {
                                language = "japanese";
                                break;
                            }
                            case 9: {
                                language = "norwegian";
                                break;
                            }
                            case 10: {
                                language = "polish";
                                break;
                            }
                            case 11: {
                                language = "portuguese";
                                break;
                            }
                            case 12: {
                                language = "russian";
                                break;
                            }
                            case 13: {
                                language = "spanish";
                                break;
                            }
                            case 14: {
                                language = "swedish";
                                break;
                            }
                            default: {
                                int result = JOptionPane.showConfirmDialog(this.frame, "Firestar encountered an internal error.\nString 'language' exported to FSCRIPT was blank.", "Fatal Error", -1, 0);
                                if (result != 0) break;
                                System.exit(1);
                            }
                        }
                        ps.println("file \"data/plugins/languages/" + language + "/entries.xml\" xml " + ocmd + " StringTable.entry#MT_" + trackno + " set attribute \"string\" \"" + (String)oArtistLine + oTitle.replace("\"", "\\\"") + "\"");
                    }
                    ps.println("file \"data/audio/music/" + trackno + "/music_stereo.fft\" delete");
                    this.progressDialog.setProgressValue(i + 1);
                }
                for (int s = this.tracklist.size(); s < 12; ++s) {
                    ps.println("file \"data/audio/music/" + String.format("%02d", s + 1) + "/music_stereo.fft\" delete");
                }
                if (this.sptrack != null) {
                    this.progressDialog.setText("Encoding singleplayer frontend track...");
                    if (this.sptrack.exists()) {
                        try {
                            Process p;
                            System.out.println("Encoding singleplayer frontend track...");
                            if (this.normalizeVolumes) {
                                new File(Main.inpath + "temp/ffmpeg/").mkdirs();
                                p = Main.exec(new String[]{Main.inpath + "ffmpeg.exe", "-y", "-i", this.sptrack.getPath(), "-filter", "loudnorm=linear=true:i=-10.0:lra=12.0:tp=-2.0", "-ar", "44100", "ffmpeg/" + this.sptrack.getName() + "_normalized.wav"}, Main.inpath + "temp/");
                                ioThread = new Thread(){

                                    @Override
                                    public void run() {
                                        Main.printProcessLogToStdOut(p);
                                    }
                                };
                                ioThread.start();
                                p.waitFor();
                                this.sptrack = new File(Main.inpath + "temp/ffmpeg/" + this.sptrack.getName() + "_normalized.wav");
                            } else {
                                new File(Main.inpath + "temp/ffmpeg/").mkdirs();
                                p = Main.exec(new String[]{Main.inpath + "ffmpeg.exe", "-y", "-i", this.sptrack.getPath(), "-ar", "44100", "ffmpeg/" + this.sptrack.getName() + ".wav"}, Main.inpath + "temp/");
                                ioThread = new Thread(){

                                    @Override
                                    public void run() {
                                        Main.printProcessLogToStdOut(p);
                                    }
                                };
                                ioThread.start();
                                p.waitFor();
                                this.sptrack = new File(Main.inpath + "temp/ffmpeg/" + this.sptrack.getName() + ".wav");
                            }
                            new File(Main.inpath + "temp/data/audio/music/FEMusic").mkdirs();
                            p = Main.exec(new String[]{Main.inpath + "at9tool.exe", "-e", "-br", "144", this.sptrack.getPath(), "data/audio/music/FEMusic/frontend_stereo.at9"}, System.getProperty("user.home") + "/.firestar/temp/");
                            ioThread = new Thread(){

                                @Override
                                public void run() {
                                    Main.printProcessLogToStdOut(p);
                                }
                            };
                            ioThread.start();
                            p.waitFor();
                            Main.deleteDir(new File(Main.inpath + "temp/ffmpeg/"));
                        }
                        catch (IOException | InterruptedException ex) {
                            Logger.getLogger(Suggs.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    ps.println("file \"data/audio/music/FEMusic/frontend_stereo.fft\" delete");
                    this.progressDialog.setProgressValue(this.progressDialog.getProgressValue() + 1);
                }
                if (this.mptrack != null) {
                    this.progressDialog.setText("Encoding multiplayer frontend track...");
                    try {
                        Process p;
                        assert (this.mptrack.exists());
                        System.out.println("Encoding multiplayer frontend track...");
                        if (this.normalizeVolumes) {
                            new File(Main.inpath + "temp/ffmpeg/").mkdirs();
                            p = Main.exec(new String[]{Main.inpath + "ffmpeg.exe", "-y", "-i", this.mptrack.getPath(), "-filter", "loudnorm=linear=true:i=-10.0:lra=12.0:tp=-2.0", "-ar", "44100", "ffmpeg/" + this.mptrack.getName() + "_normalized.wav"}, Main.inpath + "temp/");
                            ioThread = new Thread(){

                                @Override
                                public void run() {
                                    Main.printProcessLogToStdOut(p);
                                }
                            };
                            ioThread.start();
                            p.waitFor();
                            this.mptrack = new File(Main.inpath + "temp/ffmpeg/" + this.mptrack.getName() + "_normalized.wav");
                        } else {
                            new File(Main.inpath + "temp/ffmpeg/").mkdirs();
                            p = Main.exec(new String[]{Main.inpath + "ffmpeg.exe", "-y", "-i", this.mptrack.getPath(), "-ar", "44100", "ffmpeg/" + this.mptrack.getName() + ".wav"}, Main.inpath + "temp/");
                            ioThread = new Thread(){

                                @Override
                                public void run() {
                                    Main.printProcessLogToStdOut(p);
                                }
                            };
                            ioThread.start();
                            p.waitFor();
                            this.mptrack = new File(Main.inpath + "temp/ffmpeg/" + this.mptrack.getName() + ".wav");
                        }
                        new File(Main.inpath + "temp/data/audio/music/FEDemoMusic").mkdirs();
                        p = Main.exec(new String[]{Main.inpath + "at9tool.exe", "-e", "-br", "144", this.mptrack.getPath(), "data/audio/music/FEDemoMusic/frontend_stereo.at9"}, System.getProperty("user.home") + "/.firestar/temp/");
                        ioThread = new Thread(){

                            @Override
                            public void run() {
                                Main.printProcessLogToStdOut(p);
                            }
                        };
                        ioThread.start();
                        p.waitFor();
                        Main.deleteDir(new File(Main.inpath + "temp/ffmpeg/"));
                    }
                    catch (IOException | InterruptedException ex) {
                        Logger.getLogger(Suggs.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ps.println("file \"data/audio/music/FEDemoMusic/frontend_stereo.fft\" delete");
                    this.progressDialog.setProgressValue(this.progressDialog.getProgressValue() + 1);
                }
                System.out.println("Finished encoding.");
                this.progressDialog.setText("Generating Music Definitions...");
                try {
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document defDoc = docBuilder.newDocument();
                    Element docScreen = defDoc.createElement("Screen");
                    docScreen.setAttribute("name", "Top");
                    for (int i = 0; i < this.tracklist.size(); ++i) {
                        AudioTrack at = this.tracklist.get(i);
                        String trackno = String.format("%02d", i + 1);
                        Element trackElem = defDoc.createElement("PI_Music");
                        trackElem.setAttribute("name", trackno);
                        Element pathElem = defDoc.createElement("Values");
                        pathElem.setAttribute("location", "data\\audio\\music\\" + trackno);
                        trackElem.appendChild(pathElem);
                        Element artistElem = defDoc.createElement("Entry");
                        artistElem.setAttribute("Artist", at.artist);
                        trackElem.appendChild(artistElem);
                        Element titleElem = defDoc.createElement("Entry");
                        titleElem.setAttribute("Label", at.title);
                        trackElem.appendChild(titleElem);
                        docScreen.appendChild(trackElem);
                        System.out.println("Adding \"" + trackno + ". " + at.artist + " - " + at.title + "\" to Definition.xml");
                    }
                    defDoc.appendChild(docScreen);
                    new File(Main.inpath + "temp/data/plugins/music/").mkdirs();
                    FileOutputStream output = new FileOutputStream(Main.inpath + "temp/data/plugins/music/Definition.xml");
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(defDoc);
                    StreamResult result = new StreamResult(output);
                    transformer.transform(source, result);
                }
                catch (IOException | ParserConfigurationException | TransformerException ex) {
                    Logger.getLogger(Suggs.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.progressDialog.setProgressValue(this.progressDialog.getProgressValue() + 1);
                this.progressDialog.setText("Finalizing script...");
                System.out.println("Finalizing Fscript...");
                ps.println("# END FIRESTAR AUTOGENERATION");
                ps.close();
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Suggs.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.progressDialog.setProgressValue(this.progressDialog.getProgressValue() + 1);
            this.progressDialog.destroyDialog();
            this.frame.dispose();
            Clifford saveDialog = new Clifford();
            saveDialog.isSoundtrack = true;
            saveDialog.Action(this.frame, new File(Main.inpath + "temp/"));
            this.parent.setEnabled(true);
        }).start();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JLabel jLabel5;
        JLabel jLabel6;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JButton jButton9;
        JCheckBox jCheckBox2;
        JButton jButton10;
        JList jList;
        JPanel jPanel;
        this.frameContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        ((Component)jPanel).setBackground(new Color(-15128227));
        Font font = this.$$$getFont$$$("Exo 2", -1, -1, jPanel.getFont());
        if (font != null) {
            jPanel.setFont(font);
        }
        ((Component)jPanel).setForeground(new Color(-1));
        JScrollPane jScrollPane = new JScrollPane();
        ((Component)jScrollPane).setBackground(new Color(-15128227));
        Font font2 = this.$$$getFont$$$("Exo 2", -1, -1, jScrollPane.getFont());
        if (font2 != null) {
            jScrollPane.setFont(font2);
        }
        ((Component)jScrollPane).setForeground(new Color(-1));
        jScrollPane.setOpaque(false);
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), "Song List", 0, 0, this.$$$getFont$$$("Exo 2", -1, -1, jScrollPane.getFont()), new Color(-1)));
        this.dSongList = jList = new JList();
        ((Component)jList).setBackground(new Color(-15128227));
        ((Component)jList).setForeground(new Color(-1));
        jList.setOpaque(true);
        jList.setSelectionBackground(new Color(-2271221));
        jList.setSelectionForeground(new Color(-1));
        jScrollPane.setViewportView(jList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-15128227));
        ((Component)jPanel2).setForeground(new Color(-1));
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.cancelBtn = jButton10 = new JButton();
        ((Component)jButton10).setBackground(new Color(-2271221));
        jButton10.setBorderPainted(false);
        jButton10.setFocusPainted(false);
        Font font3 = this.$$$getFont$$$("Exo 2", -1, -1, jButton10.getFont());
        if (font3 != null) {
            jButton10.setFont(font3);
        }
        ((Component)jButton10).setForeground(new Color(-1));
        jButton10.setText("Cancel");
        jPanel2.add((Component)jButton10, new GridConstraints(2, 1, 1, 1, 2, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 3, 1, 0, 1, 6, 1, null, null, null));
        this.checkAdditive = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setFocusPainted(false);
        Font font4 = this.$$$getFont$$$("Exo 2", -1, -1, jCheckBox2.getFont());
        if (font4 != null) {
            jCheckBox2.setFont(font4);
        }
        ((Component)jCheckBox2).setForeground(new Color(-1));
        jCheckBox2.setOpaque(false);
        jCheckBox2.setText("Append to default playlist");
        jCheckBox2.setToolTipText("Check this box to add your playlist to the existing in-game one instead of overwriting it.");
        ((Component)jCheckBox2).setVisible(false);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 2, 10, 0, 3, 0, null, null, null));
        this.saveBtn = jButton9 = new JButton();
        ((Component)jButton9).setBackground(new Color(-2271221));
        jButton9.setBorderPainted(false);
        jButton9.setFocusPainted(false);
        Font font5 = this.$$$getFont$$$("Exo 2", -1, -1, jButton9.getFont());
        if (font5 != null) {
            jButton9.setFont(font5);
        }
        ((Component)jButton9).setForeground(new Color(-1));
        jButton9.setText("Save");
        jPanel2.add((Component)jButton9, new GridConstraints(2, 2, 1, 1, 2, 1, 3, 0, null, null, null));
        this.checkNormalize = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setFocusPainted(false);
        Font font6 = this.$$$getFont$$$("Exo 2", -1, -1, jCheckBox.getFont());
        if (font6 != null) {
            jCheckBox.setFont(font6);
        }
        ((Component)jCheckBox).setForeground(new Color(-1));
        jCheckBox.setOpaque(false);
        jCheckBox.setText("Normalize Volumes");
        jCheckBox.setToolTipText("Prevents sound effects from drowning out the music, but may reduce sound quality. This process is SKIPPED for ATRAC9 files since they are never transcoded!");
        ((Component)jCheckBox).setVisible(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 2, 10, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-15128227));
        ((Component)jPanel3).setForeground(new Color(-1));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 3, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel7 = new JLabel();
        ((Component)jLabel7).setBackground(new Color(-15128227));
        ((Component)jLabel7).setForeground(new Color(-1));
        jLabel7.setText("Title");
        jPanel3.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.fTitle = jTextField2 = new JTextField();
        jTextField2.setDisabledTextColor(new Color(-10124141));
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        ((Component)jLabel8).setBackground(new Color(-15128227));
        ((Component)jLabel8).setForeground(new Color(-1));
        jLabel8.setText("Artist");
        jPanel3.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.fArtist = jTextField = new JTextField();
        jTextField.setDisabledTextColor(new Color(-10124141));
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setBackground(new Color(-15128227));
        ((Component)jPanel4).setForeground(new Color(-1));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.dTrackNo = jLabel6 = new JLabel();
        ((Component)jLabel6).setBackground(new Color(-15128227));
        ((Component)jLabel6).setForeground(new Color(-1));
        jLabel6.setText("track # here (in MT_xx format)");
        jPanel4.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 6, 0, 0, 0, null, null, null));
        this.dFileSize = jLabel5 = new JLabel();
        ((Component)jLabel5).setBackground(new Color(-15128227));
        ((Component)jLabel5).setForeground(new Color(-1));
        jLabel5.setText("file size here");
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setOpaque(false);
        jPanel.add((Component)jPanel5, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(600, -1)));
        this.frontendDemoChooseBtn = jButton8 = new JButton();
        ((Component)jButton8).setBackground(new Color(-2271221));
        jButton8.setBorderPainted(false);
        jButton8.setFocusPainted(false);
        Font font7 = this.$$$getFont$$$("Exo 2", -1, -1, jButton8.getFont());
        if (font7 != null) {
            jButton8.setFont(font7);
        }
        ((Component)jButton8).setForeground(new Color(-1));
        jButton8.setText("Select Multiplayer Menu Track");
        jPanel5.add((Component)jButton8, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.frontendMainChooseBtn = jButton7 = new JButton();
        ((Component)jButton7).setBackground(new Color(-2271221));
        jButton7.setBorderPainted(false);
        jButton7.setFocusPainted(false);
        Font font8 = this.$$$getFont$$$("Exo 2", -1, -1, jButton7.getFont());
        if (font8 != null) {
            jButton7.setFont(font8);
        }
        ((Component)jButton7).setForeground(new Color(-1));
        jButton7.setText("Select Singleplayer Menu Track");
        jPanel5.add((Component)jButton7, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.deleteSongBtn = jButton6 = new JButton();
        ((Component)jButton6).setBackground(new Color(-2271221));
        jButton6.setBorderPainted(false);
        jButton6.setFocusPainted(false);
        Font font9 = this.$$$getFont$$$("Exo 2", -1, -1, jButton6.getFont());
        if (font9 != null) {
            jButton6.setFont(font9);
        }
        ((Component)jButton6).setForeground(new Color(-1));
        jButton6.setText("Delete Song");
        jPanel5.add((Component)jButton6, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.moveDownBtn = jButton5 = new JButton();
        ((Component)jButton5).setBackground(new Color(-2271221));
        jButton5.setBorderPainted(false);
        jButton5.setFocusPainted(false);
        Font font10 = this.$$$getFont$$$("Exo 2", -1, -1, jButton5.getFont());
        if (font10 != null) {
            jButton5.setFont(font10);
        }
        ((Component)jButton5).setForeground(new Color(-1));
        jButton5.setText("Move Down");
        jPanel5.add((Component)jButton5, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.addSongBtn = jButton4 = new JButton();
        ((Component)jButton4).setBackground(new Color(-2271221));
        jButton4.setBorderPainted(false);
        jButton4.setFocusPainted(false);
        Font font11 = this.$$$getFont$$$("Exo 2", -1, -1, jButton4.getFont());
        if (font11 != null) {
            jButton4.setFont(font11);
        }
        ((Component)jButton4).setForeground(new Color(-1));
        jButton4.setText("Add Song");
        jPanel5.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.moveUpBtn = jButton3 = new JButton();
        ((Component)jButton3).setBackground(new Color(-2271221));
        jButton3.setBorderPainted(false);
        jButton3.setFocusPainted(false);
        Font font12 = this.$$$getFont$$$("Exo 2", -1, -1, jButton3.getFont());
        if (font12 != null) {
            jButton3.setFont(font12);
        }
        ((Component)jButton3).setForeground(new Color(-1));
        jButton3.setText("Move Up");
        jPanel5.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(2, 2, 2, 2), -1, -1, false, false));
        jPanel6.setOpaque(false);
        jPanel.add((Component)jPanel6, new GridConstraints(3, 1, 1, 1, 1, 1, 3, 3, null, new Dimension(-1, 100), new Dimension(-1, 300)));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-1)), "Info", 0, 0, this.$$$getFont$$$("Exo 2", -1, -1, jPanel6.getFont()), new Color(-1)));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.setOpaque(false);
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel9 = new JLabel();
        Font font13 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel9.getFont());
        if (font13 != null) {
            jLabel9.setFont(font13);
        }
        ((Component)jLabel9).setForeground(new Color(-1));
        jLabel9.setText("Menu:");
        jPanel7.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        Font font14 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel10.getFont());
        if (font14 != null) {
            jLabel10.setFont(font14);
        }
        ((Component)jLabel10).setForeground(new Color(-1));
        jLabel10.setText("Lobby:");
        jPanel7.add((Component)jLabel10, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.dSTitle = jLabel4 = new JLabel();
        Font font15 = this.$$$getFont$$$("Exo 2", 2, -1, jLabel4.getFont());
        if (font15 != null) {
            jLabel4.setFont(font15);
        }
        ((Component)jLabel4).setForeground(new Color(-1));
        jLabel4.setText("no track");
        jPanel7.add((Component)jLabel4, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.dMTitle = jLabel3 = new JLabel();
        Font font16 = this.$$$getFont$$$("Exo 2", 2, -1, jLabel3.getFont());
        if (font16 != null) {
            jLabel3.setFont(font16);
        }
        ((Component)jLabel3).setForeground(new Color(-1));
        jLabel3.setText("no track");
        jPanel7.add((Component)jLabel3, new GridConstraints(5, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.dSSize = jLabel2 = new JLabel();
        Font font17 = this.$$$getFont$$$("Exo 2", 2, -1, jLabel2.getFont());
        if (font17 != null) {
            jLabel2.setFont(font17);
        }
        ((Component)jLabel2).setForeground(new Color(-1));
        jLabel2.setText("no size");
        jPanel7.add((Component)jLabel2, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.dMSize = jLabel = new JLabel();
        Font font18 = this.$$$getFont$$$("Exo 2", 2, -1, jLabel.getFont());
        if (font18 != null) {
            jLabel.setFont(font18);
        }
        ((Component)jLabel).setForeground(new Color(-1));
        jLabel.setText("no size");
        jPanel7.add((Component)jLabel, new GridConstraints(6, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(3, 0, 1, 3, 0, 3, 1, 6, null, null, null));
        this.spDeleteBtn = jButton2 = new JButton();
        ((Component)jButton2).setBackground(new Color(-2271221));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        ((Component)jButton2).setForeground(new Color(-1));
        jButton2.setText("Remove");
        ((Component)jButton2).setVisible(false);
        jPanel7.add((Component)jButton2, new GridConstraints(0, 1, 1, 2, 5, 0, 1, 1, null, null, null));
        this.mpDeleteBtn = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-2271221));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        ((Component)jButton).setForeground(new Color(-1));
        jButton.setText("Remove");
        ((Component)jButton).setVisible(false);
        jPanel7.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 5, 0, 1, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.frameContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    public class AudioTrack {
        public File path;
        public String title;
        public String artist;
        public long size;
        public boolean noConvert;
    }
}

