/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLDocument;

public class WilkinsCoffee
implements ActionListener {
    Image logo;
    public Pages page;
    public JFrame frame;
    private JPanel frameContainer;
    private JLabel picLabel;
    private JEditorPane instructions;
    private JButton contBtn;
    private JPanel inputContainer;
    private JButton PSARC_downBtn;
    private JButton PSARC_impBtn;
    private JPanel inputContainer2;
    private JButton EXPORT_openFolderBtn;
    private JLabel pathDisplay;
    private JPanel checklistContainer;
    private JLabel checklistFury;
    private JLabel checklistHD;
    private JLabel checklistPatch2;
    private JLabel checklistPatch1;
    private JLabel checklistBase;
    private String outPathTemp;
    private boolean sdkInstalled;

    public WilkinsCoffee() {
        this.$$$setupUI$$$();
        this.frame = new JFrame();
        this.outPathTemp = System.getProperty("user.home") + "/Documents/";
        this.sdkInstalled = false;
    }

    public void setup() {
        this.page = Pages.INTRO;
        this.inputContainer.setVisible(false);
        this.checklistContainer.setVisible(false);
        this.inputContainer2.setVisible(false);
        if (System.getProperty("os.name").contains("Windows")) {
            Main.windows = true;
            System.out.println("Assuming we should NOT use WINE based on known system variables.");
        } else {
            Main.windows = false;
            System.out.println("Assuming we should use WINE based on known system variables.");
        }
        if (Main.windows) {
            this.outPathTemp.replace("/", "\\");
        }
        this.frame.setIconImage(Main.windowIcon);
        try {
            this.logo = ImageIO.read(Main.class.getResourceAsStream("/programIcon.png")).getScaledInstance(96, 96, 4);
            this.picLabel.setIcon(new ImageIcon(this.logo));
            this.picLabel.setText("");
        }
        catch (IOException e) {
            System.out.println("ERROR: Missing resource in Wilkins. Page will be without images.");
            this.picLabel.setText("");
        }
        String bodyRule = "html, body {margin:0px;} p#first-p {margin-top:-13px;} p {margin-left:-20px;}";
        ((HTMLDocument)this.instructions.getDocument()).getStyleSheet().addRule(bodyRule);
        this.instructions.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.contBtn.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.PSARC_downBtn.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.PSARC_impBtn.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.EXPORT_openFolderBtn.setFont(Main.fExo2.deriveFont(1).deriveFont(12.0f));
        this.frame.add(this.frameContainer);
        this.contBtn.addActionListener(this);
        this.PSARC_downBtn.addActionListener(this);
        this.PSARC_impBtn.addActionListener(this);
        this.EXPORT_openFolderBtn.addActionListener(this);
        this.frame.setSize(400, 400);
        this.frame.setTitle("Firestar Setup");
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new GridLayout());
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final WilkinsCoffee threadParent = this;
        if (actionEvent.getSource() == this.PSARC_downBtn) {
            Thread waiterThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (new Bert(WilkinsCoffee.this.frame).reportWhenDownloaded(threadParent)) {
                        WilkinsCoffee.this.contBtn.setEnabled(true);
                        WilkinsCoffee.this.contBtn.setBackground(new Color(221, 88, 11));
                        WilkinsCoffee.this.refreshChecklist();
                    }
                }
            });
            waiterThread.start();
        } else if (actionEvent.getSource() == this.PSARC_impBtn) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            FileNameExtensionFilter fileChooserFilter = new FileNameExtensionFilter("Sony Playstation Archive File", "psarc");
            fileChooser.setFileFilter(fileChooserFilter);
            int result = fileChooser.showOpenDialog(this.frame);
            if (result == 0) {
                try {
                    Files.copy(fileChooser.getSelectedFile().toPath(), new File(Main.inpath + fileChooser.getSelectedFile().getName()).toPath(), new CopyOption[0]);
                    this.refreshChecklist();
                    this.contBtn.setEnabled(true);
                    this.contBtn.setBackground(new Color(221, 88, 11));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    JOptionPane.showMessageDialog(this.frame, "An error has occured.\n" + e.getMessage(), "Error", 0);
                }
            }
        } else if (actionEvent.getSource() == this.EXPORT_openFolderBtn) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            int result = fileChooser.showOpenDialog(this.frame);
            if (result == 0 && fileChooser.getSelectedFile().isDirectory()) {
                this.outPathTemp = fileChooser.getSelectedFile().getAbsolutePath() + "/";
                this.pathDisplay.setText("Export path: " + this.outPathTemp);
            }
        } else if (actionEvent.getSource() == this.contBtn) {
            switch (this.page) {
                case INTRO: {
                    if (!new File(Main.inpath + "psp2psarc.exe").exists()) {
                        this.frame.setEnabled(false);
                        int result = JOptionPane.showConfirmDialog(this.frame, "Firestar needs to download additional software to function. Setup is automatic and will only take a few minutes.\nIf you select NO, you will have to download additional dependencies later on.\n\nContinue?", "Firestar Setup", 0, 3);
                        if (result == 0) {
                            this.sdkInstalled = true;
                            Thread downloaderPopupThread = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    Main.downloadDependenciesBeforeSetVisible(WilkinsCoffee.this.frame);
                                    WilkinsCoffee.this.frame.setEnabled(true);
                                }
                            });
                            downloaderPopupThread.start();
                        } else {
                            this.frame.setEnabled(true);
                        }
                    } else {
                        this.sdkInstalled = true;
                    }
                    this.page = Pages.PSARC;
                    try {
                        this.logo = ImageIO.read(Main.class.getResourceAsStream("/setupIconPSARC.png")).getScaledInstance(96, 96, 4);
                        this.picLabel.setIcon(new ImageIcon(this.logo));
                        this.picLabel.setText("");
                    }
                    catch (IOException e) {
                        System.out.println("ERROR: Missing resource in Wilkins. Page will be without images.");
                        this.picLabel.setText("");
                    }
                    this.contBtn.setEnabled(false);
                    this.contBtn.setBackground(new Color(102, 74, 58));
                    this.refreshChecklist();
                    this.inputContainer.setVisible(true);
                    this.checklistContainer.setVisible(true);
                    if (!this.sdkInstalled) {
                        this.PSARC_downBtn.setEnabled(false);
                        this.PSARC_downBtn.setBackground(new Color(102, 74, 58));
                    }
                    this.instructions.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n    <p id=\"first-p\">\n      You must dump the original assets from WipEout 2048 so that Firestar can patch them.<br><br>If you would like, you can choose to have these downloaded and extracted for you, or you can provide your own decrypted dumps.</p><p>To decrypt your own dumps, please see \"Decrypting Original PSARC Files\" in the manual.\n    </p>\n    <p>\n      Press &quot;Continue&quot; when you are done.\n    </p>\n  </body>\n</html>\n");
                    break;
                }
                case PSARC: {
                    this.page = Pages.EXPORT_LOCATION;
                    try {
                        this.logo = ImageIO.read(Main.class.getResourceAsStream("/setupIconEXPORT.png")).getScaledInstance(96, 96, 4);
                        this.picLabel.setIcon(new ImageIcon(this.logo));
                        this.picLabel.setText("");
                    }
                    catch (IOException e) {
                        System.out.println("ERROR: Missing resource in Wilkins. Page will be without images.");
                        this.picLabel.setText("");
                    }
                    this.contBtn.setEnabled(true);
                    this.contBtn.setBackground(new Color(221, 88, 11));
                    this.inputContainer.setVisible(false);
                    this.checklistContainer.setVisible(false);
                    this.inputContainer2.setVisible(true);
                    this.instructions.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n    <p id=\"first-p\">\n      Almost done!<br><br>Select the folder you would like to export your compiled mods to.<br><br>When you select \"Deploy\" in the mod list, Firestar will place a PSARC file into this folder which you can install onto your Vita.\n    </p>\n    <p>\n      Press &quot;Continue&quot; when you are done.\n    </p>\n  </body>\n</html>\n");
                    this.pathDisplay.setText("Export path: " + this.outPathTemp);
                    break;
                }
                case EXPORT_LOCATION: {
                    this.page = Pages.DONE;
                    try {
                        this.logo = ImageIO.read(Main.class.getResourceAsStream("/setupIconDONE.png")).getScaledInstance(96, 96, 4);
                        this.picLabel.setIcon(new ImageIcon(this.logo));
                        this.picLabel.setText("");
                    }
                    catch (IOException e) {
                        System.out.println("ERROR: Missing resource in Wilkins. Page will be without images.");
                        this.picLabel.setText("");
                    }
                    this.inputContainer2.setVisible(false);
                    Main.outpath = this.outPathTemp;
                    Main.repatch = true;
                    Main.writeConf();
                    this.instructions.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n    <p id=\"first-p\">\n      Setup complete!\n    </p>\n  </body>\n</html>\n");
                    break;
                }
                case DONE: {
                    this.frame.dispose();
                    new MissPiggy().Action();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("ERROR: Setup page-flip event listener didn't drink any Wilkins Coffee. Get a programmer!");
                }
            }
        }
    }

    private void refreshChecklist() {
        ImageIcon positive = new ImageIcon(Main.class.getResource("/lightPositive.png"));
        ImageIcon negative = new ImageIcon(Main.class.getResource("/lightNegative.png"));
        if (new File(Main.inpath + "data.psarc").exists()) {
            this.checklistBase.setIcon(positive);
            this.contBtn.setEnabled(true);
            this.contBtn.setBackground(new Color(221, 88, 11));
        } else {
            this.checklistBase.setIcon(negative);
        }
        if (new File(Main.inpath + "data1.psarc").exists()) {
            this.checklistPatch1.setIcon(positive);
            this.contBtn.setEnabled(true);
            this.contBtn.setBackground(new Color(221, 88, 11));
        } else {
            this.checklistPatch1.setIcon(negative);
        }
        if (new File(Main.inpath + "data2.psarc").exists()) {
            this.checklistPatch2.setIcon(positive);
            this.contBtn.setEnabled(true);
            this.contBtn.setBackground(new Color(221, 88, 11));
        } else {
            this.checklistPatch2.setIcon(negative);
        }
        if (new File(Main.inpath + "dlc1.psarc").exists()) {
            this.checklistHD.setIcon(positive);
            this.contBtn.setEnabled(true);
            this.contBtn.setBackground(new Color(221, 88, 11));
        } else {
            this.checklistHD.setIcon(negative);
        }
        if (new File(Main.inpath + "dlc2.psarc").exists()) {
            this.checklistFury.setIcon(positive);
            this.contBtn.setEnabled(true);
            this.contBtn.setBackground(new Color(221, 88, 11));
        } else {
            this.checklistFury.setIcon(negative);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JPanel jPanel;
        JLabel jLabel6;
        JButton jButton;
        JPanel jPanel2;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel3;
        JButton jButton4;
        JEditorPane jEditorPane;
        JLabel jLabel7;
        JPanel jPanel4;
        this.frameContainer = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        ((Component)jPanel4).setBackground(new Color(-15128227));
        ((Component)jPanel4).setForeground(new Color(-1));
        this.picLabel = jLabel7 = new JLabel();
        ((Component)jLabel7).setForeground(new Color(-1));
        jLabel7.setText("Image");
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 1, 1, 1, 1, null, new Dimension(76, 76), new Dimension(96, 96)));
        this.instructions = jEditorPane = new JEditorPane();
        ((Component)jEditorPane).setBackground(new Color(-15128227));
        jEditorPane.setContentType("text/html");
        jEditorPane.setDisabledTextColor(new Color(-592129));
        jEditorPane.setEditable(false);
        ((Component)jEditorPane).setEnabled(false);
        jEditorPane.setFocusCycleRoot(false);
        jEditorPane.setFocusable(false);
        Font font = this.$$$getFont$$$("Exo 2", -1, 14, jEditorPane.getFont());
        if (font != null) {
            jEditorPane.setFont(font);
        }
        ((Component)jEditorPane).setForeground(new Color(-1));
        jEditorPane.setMargin(new Insets(0, 5, 0, 0));
        jEditorPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n    <p id=\"first-p\">\n      Welcome to the Firestar Setup.\n    </p>\n    <p>\n      Please read the manual before continuing, and make sure your Vita is \n      configured correctly first. You will need enso custom firmware and \n      Repatch Reloaded for Firestar to work.<br><br>Emulator players can skip \n      these preparations.\n    </p>\n    <p>\n      Press &quot;Continue&quot; when you are ready.\n    </p>\n  </body>\n</html>\n");
        jPanel4.add((Component)jEditorPane, new GridConstraints(0, 1, 2, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null, 1));
        this.contBtn = jButton4 = new JButton();
        ((Component)jButton4).setBackground(new Color(-2271221));
        jButton4.setBorderPainted(false);
        jButton4.setFocusPainted(false);
        ((Component)jButton4).setForeground(new Color(-1));
        jButton4.setText("Continue");
        jPanel4.add((Component)jButton4, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.inputContainer = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 3, 0), -1, -1, false, false));
        ((Component)jPanel3).setBackground(new Color(-15128227));
        jPanel3.setFocusable(false);
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.PSARC_impBtn = jButton3 = new JButton();
        ((Component)jButton3).setBackground(new Color(-2271221));
        jButton3.setBorderPainted(false);
        jButton3.setFocusPainted(false);
        ((Component)jButton3).setForeground(new Color(-1));
        jButton3.setText("Import My Own");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 2, 1, 3, 0, null, null, null));
        this.PSARC_downBtn = jButton2 = new JButton();
        ((Component)jButton2).setBackground(new Color(-2271221));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        ((Component)jButton2).setForeground(new Color(-1));
        jButton2.setText("Auto-Download");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        this.inputContainer2 = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 3, 0), -1, -1, false, false));
        ((Component)jPanel2).setBackground(new Color(-15128227));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.EXPORT_openFolderBtn = jButton = new JButton();
        ((Component)jButton).setBackground(new Color(-2271221));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        ((Component)jButton).setForeground(new Color(-1));
        jButton.setText("Select Folder");
        jPanel2.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.pathDisplay = jLabel6 = new JLabel();
        Font font2 = this.$$$getFont$$$("Exo 2", -1, 12, jLabel6.getFont());
        if (font2 != null) {
            jLabel6.setFont(font2);
        }
        ((Component)jLabel6).setForeground(new Color(-1));
        jLabel6.setText("Your Documents folder is selected by default.");
        jPanel2.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.checklistContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setBackground(new Color(-15128227));
        Font font3 = this.$$$getFont$$$("Exo 2", -1, -1, jPanel.getFont());
        if (font3 != null) {
            jPanel.setFont(font3);
        }
        ((Component)jPanel).setForeground(new Color(-1));
        jPanel.setOpaque(false);
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 2, 1, 3, 3, null, null, null));
        this.checklistFury = jLabel5 = new JLabel();
        ((Component)jLabel5).setBackground(new Color(-15128227));
        Font font4 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel5.getFont());
        if (font4 != null) {
            jLabel5.setFont(font4);
        }
        ((Component)jLabel5).setForeground(new Color(-1));
        jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel5.setText("Fury DLC");
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checklistHD = jLabel4 = new JLabel();
        ((Component)jLabel4).setBackground(new Color(-15128227));
        Font font5 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel4.getFont());
        if (font5 != null) {
            jLabel4.setFont(font5);
        }
        ((Component)jLabel4).setForeground(new Color(-1));
        jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel4.setText("HD DLC");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checklistPatch2 = jLabel3 = new JLabel();
        ((Component)jLabel3).setBackground(new Color(-15128227));
        Font font6 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel3.getFont());
        if (font6 != null) {
            jLabel3.setFont(font6);
        }
        ((Component)jLabel3).setForeground(new Color(-1));
        jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel3.setText("Patch 2");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checklistPatch1 = jLabel2 = new JLabel();
        ((Component)jLabel2).setBackground(new Color(-15128227));
        Font font7 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel2.getFont());
        if (font7 != null) {
            jLabel2.setFont(font7);
        }
        ((Component)jLabel2).setForeground(new Color(-1));
        jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel2.setText("Patch 1");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checklistBase = jLabel = new JLabel();
        ((Component)jLabel).setBackground(new Color(-15128227));
        Font font8 = this.$$$getFont$$$("Exo 2", -1, -1, jLabel.getFont());
        if (font8 != null) {
            jLabel.setFont(font8);
        }
        ((Component)jLabel).setForeground(new Color(-1));
        jLabel.setIcon(new ImageIcon(this.getClass().getResource("/lightNegative.png")));
        jLabel.setText("Base");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.frameContainer;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    public static enum Pages {
        INTRO(0),
        PSARC(1),
        EXPORT_LOCATION(2),
        DONE(3);

        public final int value;

        private Pages(int i) {
            this.value = i;
        }
    }
}

